/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.cache;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.fml.ModLoader;
import software.bernie.geckolib.GeckoLib;
import software.bernie.geckolib.GeckoLibException;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.loading.FileLoader;
import software.bernie.geckolib.loading.json.raw.Model;
import software.bernie.geckolib.loading.object.BakedAnimations;
import software.bernie.geckolib.loading.object.BakedModelFactory;
import software.bernie.geckolib.loading.object.GeometryTree;

public final class GeckoLibCache {
    private static final Set<String> EXCLUDED_NAMESPACES = ObjectOpenHashSet.of((Object)"moreplayermodels", (Object)"customnpcs", (Object)"gunsrpg");
    private static Map<ResourceLocation, BakedAnimations> ANIMATIONS = Collections.emptyMap();
    private static Map<ResourceLocation, BakedGeoModel> MODELS = Collections.emptyMap();

    public static Map<ResourceLocation, BakedAnimations> getBakedAnimations() {
        if (!GeckoLib.hasInitialized) {
            throw new RuntimeException("GeckoLib was never initialized! Please read the documentation!");
        }
        return ANIMATIONS;
    }

    public static Map<ResourceLocation, BakedGeoModel> getBakedModels() {
        if (!GeckoLib.hasInitialized) {
            throw new RuntimeException("GeckoLib was never initialized! Please read the documentation!");
        }
        return MODELS;
    }

    public static void registerReloadListener() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc == null) {
            if (!ModLoader.isDataGenRunning()) {
                GeckoLib.LOGGER.warn("Minecraft.getInstance() was null, could not register reload listeners");
            }
            return;
        }
        ResourceManager resourceManager = mc.m_91098_();
        if (!(resourceManager instanceof ReloadableResourceManager)) {
            throw new RuntimeException("GeckoLib was initialized too early!");
        }
        ReloadableResourceManager resourceManager2 = (ReloadableResourceManager)resourceManager;
        resourceManager2.m_7217_(GeckoLibCache::reload);
    }

    private static CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Object2ObjectOpenHashMap animations = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap models = new Object2ObjectOpenHashMap();
        CompletableFuture[] completableFutureArray = new CompletableFuture[2];
        completableFutureArray[0] = GeckoLibCache.loadAnimations(backgroundExecutor, resourceManager, ((Map)animations)::put);
        completableFutureArray[1] = GeckoLibCache.loadModels(backgroundExecutor, resourceManager, ((Map)models)::put);
        return ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> GeckoLibCache.lambda$reload$0((Map)animations, (Map)models, arg_0), gameExecutor);
    }

    private static CompletableFuture<Void> loadAnimations(Executor backgroundExecutor, ResourceManager resourceManager, BiConsumer<ResourceLocation, BakedAnimations> elementConsumer) {
        return GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "animations", resource -> {
            try {
                return FileLoader.loadAnimationsFile(resource, resourceManager);
            }
            catch (Exception ex) {
                throw new GeckoLibException((ResourceLocation)resource, "Error loading animation file", ex);
            }
        }, elementConsumer);
    }

    private static CompletableFuture<Void> loadModels(Executor backgroundExecutor, ResourceManager resourceManager, BiConsumer<ResourceLocation, BakedGeoModel> elementConsumer) {
        return GeckoLibCache.loadResources(backgroundExecutor, resourceManager, "geo", resource -> {
            try {
                Model model = FileLoader.loadModelFile(resource, resourceManager);
                if (model.formatVersion() == null) {
                    GeckoLib.LOGGER.warn("Unsupported geometry json version for model {}. Supported versions: 1.12.0", resource);
                } else {
                    switch (model.formatVersion()) {
                        case V_1_12_0: {
                            break;
                        }
                        case V_1_14_0: {
                            GeckoLib.LOGGER.warn("Unsupported geometry json version: 1.14.0 for model {}. This model may not appear as expected", resource);
                            break;
                        }
                        case V_1_21_0: {
                            GeckoLib.LOGGER.warn("Unsupported geometry json version: 1.21.0 for model {}. Supported versions: 1.12.0. Remove any rotated face UVs and re-export the model to fix", resource);
                            break;
                        }
                        case V_1_21_2: {
                            GeckoLib.LOGGER.warn("Unsupported geometry json version: 1.21.2 for model {}. Supported versions: 1.12.0. Remove any rotated face UVs and re-export the model to fix", resource);
                            break;
                        }
                        default: {
                            GeckoLib.LOGGER.warn("Unsupported geometry json version for model {}. Supported versions: 1.12.0", resource);
                        }
                    }
                }
                return BakedModelFactory.getForNamespace(resource.m_135827_()).constructGeoModel(GeometryTree.fromModel(model));
            }
            catch (Exception ex) {
                throw new GeckoLibException((ResourceLocation)resource, "Error loading model file", ex);
            }
        }, elementConsumer);
    }

    private static <T> CompletableFuture<Void> loadResources(Executor executor, ResourceManager resourceManager, String path, Function<ResourceLocation, T> loader, BiConsumer<ResourceLocation, T> map) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> resourceManager.m_214159_(path, fileName -> fileName.toString().endsWith(".json")), executor).thenApplyAsync(resources -> {
            Object2ObjectOpenHashMap tasks = new Object2ObjectOpenHashMap();
            for (ResourceLocation resource : resources.keySet()) {
                tasks.put(resource, CompletableFuture.supplyAsync(() -> loader.apply(resource), executor));
            }
            return tasks;
        }, executor)).thenAcceptAsync(tasks -> {
            for (Map.Entry entry : tasks.entrySet()) {
                if (EXCLUDED_NAMESPACES.contains(((ResourceLocation)entry.getKey()).m_135827_().toLowerCase(Locale.ROOT))) continue;
                map.accept((ResourceLocation)entry.getKey(), ((CompletableFuture)entry.getValue()).join());
            }
        }, executor);
    }

    private static /* synthetic */ void lambda$reload$0(Map animations, Map models, Void empty) {
        ANIMATIONS = animations;
        MODELS = models;
    }
}

