/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib.network.packet;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.GeoReplacedEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.util.ClientUtils;
import software.bernie.geckolib.util.RenderUtils;

public class StopTriggeredEntityAnimPacket {
    private final int entityId;
    private final boolean isReplacedEntity;
    private final String controllerName;
    private final String animName;

    public StopTriggeredEntityAnimPacket(int entityId, @Nullable String controllerName, @Nullable String animName) {
        this(entityId, false, controllerName, animName);
    }

    public StopTriggeredEntityAnimPacket(int entityId, boolean isReplacedEntity, @Nullable String controllerName, @Nullable String animName) {
        this.entityId = entityId;
        this.isReplacedEntity = isReplacedEntity;
        this.controllerName = controllerName == null ? "" : controllerName;
        this.animName = animName == null ? "" : animName;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.entityId);
        buffer.writeBoolean(this.isReplacedEntity);
        buffer.m_130070_(this.controllerName);
        buffer.m_130070_(this.animName);
    }

    public static StopTriggeredEntityAnimPacket decode(FriendlyByteBuf buffer) {
        return new StopTriggeredEntityAnimPacket(buffer.m_130242_(), buffer.readBoolean(), buffer.m_130277_(), buffer.m_130277_());
    }

    public void receivePacket(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context handler = context.get();
        handler.enqueueWork(() -> {
            Entity entity = ClientUtils.getLevel().m_6815_(this.entityId);
            if (entity == null) {
                return;
            }
            if (this.isReplacedEntity) {
                GeoAnimatable animatable = RenderUtils.getReplacedAnimatable(entity.m_6095_());
                if (animatable instanceof GeoReplacedEntity) {
                    GeoReplacedEntity replacedEntity = (GeoReplacedEntity)animatable;
                    replacedEntity.stopTriggeredAnimation(entity, this.controllerName.isEmpty() ? null : this.controllerName, this.animName.isEmpty() ? null : this.animName);
                }
            } else if (entity instanceof GeoEntity) {
                GeoEntity geoEntity = (GeoEntity)entity;
                geoEntity.stopTriggeredAnimation(this.controllerName.isEmpty() ? null : this.controllerName, this.animName.isEmpty() ? null : this.animName);
            }
        });
        handler.setPacketHandled(true);
    }
}

