/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.Collections;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.LunchBoxBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.VariableSizeContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.LunchBoxItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LunchBoxBlock
extends WaterBlock
implements EntityBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape SHAPE = LunchBoxBlock.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);
    private static final VoxelShape SHAPE_HANGING = LunchBoxBlock.m_49796_((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0);

    public LunchBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HANGING, FACING, OPEN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(context.m_43719_() == Direction.DOWN));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)HANGING) != false ? SHAPE_HANGING : SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new LunchBoxBlockTile(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (worldIn.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_()) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof LunchBoxBlockTile) {
            LunchBoxBlockTile tile = (LunchBoxBlockTile)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                VariableSizeContainerMenu.openTileMenu(sp, tile);
                PiglinAi.m_34873_((Player)player, (boolean)true);
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LunchBoxBlockTile) {
            LunchBoxBlockTile tile = (LunchBoxBlockTile)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && !tile.m_7983_()) {
                ItemStack itemstack = new ItemStack((ItemLike)this);
                LunchBoxBlock.saveTileToItem(itemstack, tile);
                ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
                itementity.m_32060_();
                level.m_7967_((Entity)itementity);
            } else {
                tile.m_59640_(player);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Object object = builder.m_287159_(LootContextParams.f_81462_);
        if (object instanceof LunchBoxBlockTile) {
            LunchBoxBlockTile tile = (LunchBoxBlockTile)((Object)object);
            ItemStack lunchBox = new ItemStack((ItemLike)this);
            LunchBoxBlock.saveTileToItem(lunchBox, tile);
            return Collections.singletonList(lunchBox);
        }
        return super.m_49635_(state, builder);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        ItemStack itemstack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LunchBoxBlockTile) {
            LunchBoxBlockTile tile = (LunchBoxBlockTile)blockEntity;
            LunchBoxBlock.saveTileToItem(itemstack, tile);
        }
        return itemstack;
    }

    private static void saveTileToItem(ItemStack itemstack, LunchBoxBlockTile tile) {
        LunchBoxItem.Data data = LunchBoxItem.getLunchBoxData(itemstack);
        if (data != null) {
            for (int inx = 0; inx < tile.m_6643_(); ++inx) {
                data.tryAdding(tile.m_8020_(inx));
            }
        } else {
            Supplementaries.error();
        }
        if (tile.m_8077_()) {
            itemstack.m_41714_(tile.m_7770_());
        }
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof LunchBoxBlockTile) {
            LunchBoxItem.Data data;
            LunchBoxBlockTile tile = (LunchBoxBlockTile)blockEntity;
            if (stack.m_41788_()) {
                tile.m_58638_(stack.m_41786_());
            }
            if ((data = LunchBoxItem.getLunchBoxData(stack)) != null) {
                int index = 0;
                for (ItemStack i : data.getContentView()) {
                    tile.m_6836_(index++, i.m_41777_());
                }
            } else {
                Supplementaries.error();
            }
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            worldIn.m_46717_(pos, state.m_60734_());
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof Container) {
            Container tile = (Container)blockEntity;
            return AbstractContainerMenu.m_38938_((Container)tile);
        }
        return 0;
    }

    public MenuProvider m_7246_(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        return blockEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)blockEntity) : null;
    }
}

