/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class WrenchItem
extends Item {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public WrenchItem(Item.Properties pProperties) {
        super(pProperties);
        this.attackDamage = 2.5f;
        float pAttackSpeedModifier = -2.0f;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public float getDamage() {
        return this.attackDamage;
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_150930_(Items.f_151052_);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pAttacker.m_9236_().m_6269_(null, (Entity)pTarget, ModSounds.WRENCH_HIT.get(), pAttacker.m_5720_(), 1.0f, 0.9f + pAttacker.m_217043_().m_188501_() * 0.2f);
        pStack.m_41622_(1, pAttacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player != null) {
            boolean shiftDown;
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            if (CompatHandler.FLAN && !FlanCompat.canPlace(player, pos)) {
                return InteractionResult.FAIL;
            }
            ItemStack itemstack = context.m_43722_();
            Direction dir = context.m_43719_();
            Optional<Direction> success = BlockUtil.tryRotatingBlockAndConnected(dir, shiftDown = player.m_6144_(), pos, level, context.m_43720_());
            if (success.isPresent()) {
                dir = success.get();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.f_10562_.m_285767_(serverPlayer, pos, itemstack);
                    level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
                }
                WrenchItem.playTurningEffects(pos, shiftDown, dir, level, player);
                itemstack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            level.m_6269_(context.m_43723_(), (Entity)player, ModSounds.WRENCH_FAIL.get(), SoundSource.PLAYERS, 1.4f, 0.8f);
        }
        return InteractionResult.FAIL;
    }

    public static void playTurningEffects(BlockPos pos, boolean shiftDown, Direction dir, Level level, Player player) {
        if (!level.f_46443_) {
            if (dir == Direction.DOWN) {
                dir = dir.m_122424_();
            }
            if (shiftDown) {
                dir = dir.m_122424_();
            }
            ModNetwork.CHANNEL.sentToAllClientPlayersTrackingEntityAndSelf((Entity)player, (Message)new ClientBoundParticlePacket(pos.m_252807_(), ClientBoundParticlePacket.Type.WRENCH_ROTATION, dir.m_122411_()));
        }
        level.m_5594_(player, pos, ModSounds.BLOCK_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        level.m_6269_(player, (Entity)player, ModSounds.WRENCH_ROTATE.get(), SoundSource.PLAYERS, 1.0f, 1.4f);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity entity, InteractionHand pUsedHand) {
        if (entity instanceof ArmorStand || entity.m_6095_().m_204039_(ModTags.ROTATABLE)) {
            boolean shiftDown = player.m_6144_();
            float inc = 22.5f * (float)(shiftDown ? -1 : 1);
            entity.m_146922_(entity.m_146908_() + inc);
            Level level = player.m_9236_();
            if (level.f_46443_) {
                WrenchItem.playTurningEffects(entity.m_20097_().m_7494_(), shiftDown, Direction.UP, level, player);
            }
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(pUsedHand));
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        return super.m_7203_(level, player, usedHand);
    }
}

