/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.explosion;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.BellowsBlock;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.TntBehavior;
import net.mehvahdjukaar.supplementaries.reg.ModFluids;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class GunpowderExplosion
extends Explosion {
    private float radius2;

    public GunpowderExplosion(Level world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, null, null, x, y, z, size, false, Explosion.BlockInteraction.DESTROY);
        this.radius2 = size;
    }

    public void m_46061_() {
        int px = Mth.m_14107_((double)this.f_46013_);
        int py = Mth.m_14107_((double)this.f_46014_);
        int pz = Mth.m_14107_((double)this.f_46015_);
        this.radius2 *= 2.0f;
        ForgeHelper.onExplosionDetonate((Level)this.f_46012_, (Explosion)this, new ArrayList(), (double)this.radius2);
        this.explodeBlock(px + 1, py, pz);
        this.explodeBlock(px - 1, py, pz);
        this.explodeBlock(px, py + 1, pz);
        this.explodeBlock(px, py - 1, pz);
        this.explodeBlock(px, py, pz + 1);
        this.explodeBlock(px, py, pz - 1);
        this.explodeBlock(px, py + 1, pz + 1);
        this.explodeBlock(px, py + 1, pz - 1);
        this.explodeBlock(px + 1, py + 1, pz);
        this.explodeBlock(px - 1, py + 1, pz);
        BlockPos pos = new BlockPos(px, py, pz);
        BlockState newFire = BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos);
        BlockState s = this.f_46012_.m_8055_(pos);
        if ((s.m_247087_() || s.m_60713_(ModRegistry.GUNPOWDER_BLOCK.get())) && (this.hasFlammableNeighbours(pos) || PlatHelper.isFireSource((BlockState)this.f_46012_.m_8055_(pos.m_7495_()), (Level)this.f_46012_, (BlockPos)pos, (Direction)Direction.UP) || newFire.m_60734_() != Blocks.f_50083_)) {
            this.f_46012_.m_46597_(pos, newFire);
        }
    }

    private boolean hasFlammableNeighbours(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState state = this.f_46012_.m_8055_(pos.m_121945_(direction));
            if (!state.m_278200_() && (state.m_60734_() != ModRegistry.BELLOWS.get() || (Integer)state.m_61143_((Property)BellowsBlock.POWER) == 0 || state.m_61143_((Property)BellowsBlock.FACING) != direction.m_122424_())) continue;
            return true;
        }
        return false;
    }

    private void explodeBlock(int i, int j, int k) {
        BlockPos pos = new BlockPos(i, j, k);
        FluidState fluidstate = this.f_46012_.m_6425_(pos);
        if (fluidstate.m_76152_() == Fluids.f_76191_ || fluidstate.m_76152_() == ModFluids.LUMISENE_FLUID.get()) {
            BlockState state = this.f_46012_.m_8055_(pos);
            Block block = state.m_60734_();
            if (ForgeHelper.getExplosionResistance((BlockState)state, (Level)this.f_46012_, (BlockPos)pos, (Explosion)this) == 0.0f) {
                if (state.m_60734_() instanceof TntBlock) {
                    this.getToBlow().add((Object)pos);
                } else if (TntBehavior.isTNTLikeBlock(state)) {
                    TntBehavior.igniteTntHack(state, this.f_46012_, pos);
                }
            }
            if (block instanceof ILightable) {
                ILightable iLightable = (ILightable)block;
                iLightable.lightUp(null, state, pos, (LevelAccessor)this.f_46012_, ILightable.FireSourceType.FLAMING_ARROW);
            } else if (GunpowderExplosion.canLight(state)) {
                this.f_46012_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
                ILightable.FireSourceType.FLAMING_ARROW.play((LevelAccessor)this.f_46012_, pos);
            }
        }
    }

    private static boolean canLight(BlockState state) {
        Block b = state.m_60734_();
        if (b instanceof AbstractCandleBlock) {
            return !AbstractCandleBlock.m_151933_((BlockState)state);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61443_) && state.m_204336_(ModTags.LIGHTABLE_BY_GUNPOWDER)) {
            return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) == false && (!state.m_61138_((Property)BlockStateProperties.f_61362_) || (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) == false);
        }
        return false;
    }

    public ObjectArrayList<BlockPos> getToBlow() {
        return (ObjectArrayList)super.m_46081_();
    }

    public void m_46075_(boolean spawnFire) {
        BlockPos pos;
        ObjectArrayList drops = new ObjectArrayList();
        Util.m_214673_(this.getToBlow(), (RandomSource)this.f_46012_.f_46441_);
        for (BlockPos blockpos : this.getToBlow()) {
            Level level;
            BlockState blockstate = this.f_46012_.m_8055_(blockpos);
            BlockPos immutable = blockpos.m_7949_();
            this.f_46012_.m_46473_().m_6180_("explosion_blocks");
            if (ForgeHelper.canDropFromExplosion((BlockState)blockstate, (Level)this.f_46012_, (BlockPos)blockpos, (Explosion)this) && (level = this.f_46012_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                BlockEntity blockEntity = blockstate.m_155947_() ? this.f_46012_.m_7702_(blockpos) : null;
                LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockEntity).m_287289_(LootContextParams.f_81455_, null);
                builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius2));
                blockstate.m_287290_(builder).forEach(d -> GunpowderExplosion.m_46067_((ObjectArrayList)drops, (ItemStack)d, (BlockPos)immutable));
            }
            ForgeHelper.onBlockExploded((BlockState)blockstate, (Level)this.f_46012_, (BlockPos)blockpos, (Explosion)this);
            this.f_46012_.m_46473_().m_7238_();
        }
        for (Pair pair : drops) {
            Block.m_49840_((Level)this.f_46012_, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
        }
        if (spawnFire && this.f_46012_.m_8055_(pos = BlockPos.m_274561_((double)this.f_46013_, (double)this.f_46014_, (double)this.f_46015_)).m_60795_() && this.f_46012_.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)this.f_46012_, pos.m_7495_())) {
            this.f_46012_.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)this.f_46012_, (BlockPos)pos));
        }
    }
}

