/*
 * Decompiled with CFR 0.152.
 */
package se.gory_moon.globalgamerules;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import se.gory_moon.globalgamerules.Config;

public class WorldEvents {
    private static final Logger LOGGER = LogManager.getLogger((String)"GlobalGameRules");

    @SubscribeEvent
    public static void onWorldJoin(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof Player) {
            Player player = (Player)entity;
            Level world = event.getLevel();
            MinecraftServer server = world.m_7654_();
            if (server != null) {
                ((List)Config.COMMON.defaultCommands.get()).forEach(s -> {
                    String command = s.replaceAll("@p", player.m_36316_().getName());
                    server.m_129892_().m_230957_(server.m_129893_(), command);
                });
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)levelAccessor;
        LevelData levelData = world.m_6106_();
        if (!(levelData instanceof PrimaryLevelData)) {
            return;
        }
        PrimaryLevelData info = (PrimaryLevelData)levelData;
        GameRules rules = info.m_5470_();
        LOGGER.info("Applying config gamerules to level {}", (Object)info.m_5462_());
        HashMap arguments = new HashMap();
        Config.COMMON.gameRules.forEach((ruleKey, configValue) -> arguments.put(ruleKey.m_46328_(), new ParsedArgument(0, 0, configValue.get())));
        CommandContext context = new CommandContext((Object)world.m_7654_().m_129893_(), null, arguments, null, null, null, null, null, null, false);
        Config.COMMON.gameRules.forEach((ruleKey, configValue) -> rules.m_46170_(ruleKey).m_46370_(context, ruleKey.m_46328_()));
        if (!info.m_5474_()) {
            Boolean hardcore = (Boolean)Config.COMMON.hardcore.get();
            if (info.m_5466_() != hardcore.booleanValue()) {
                LevelSettings settings = info.f_78443_;
                info.f_78443_ = new LevelSettings(settings.m_46917_(), settings.m_46929_(), hardcore.booleanValue(), settings.m_46931_(), settings.m_46932_(), settings.m_46933_(), settings.m_246291_());
                if (hardcore.booleanValue() && info.m_5472_() != Difficulty.HARD) {
                    world.m_7654_().m_129827_(Difficulty.HARD, false);
                }
                if (hardcore.booleanValue()) {
                    LOGGER.info("Enabling hardcore in level {}", (Object)info.m_5462_());
                } else {
                    LOGGER.info("Disabling hardcore in level {}", (Object)info.m_5462_());
                }
            }
            if (((Boolean)Config.COMMON.setDifficulty.get()).booleanValue()) {
                Difficulty diff = (Difficulty)Config.COMMON.difficulty.get();
                world.m_7654_().m_129827_(diff, false);
                LOGGER.info("Setting difficulty of level {} to {}", (Object)info.m_5462_(), (Object)diff.toString());
            }
        }
        if (((Boolean)Config.COMMON.lockDifficulty.get()).booleanValue()) {
            world.m_7654_().m_129958_(true);
            LOGGER.info("Locking difficulty of level {}", (Object)info.m_5462_());
        }
    }

    @SubscribeEvent
    public static void onWorldUnLoad(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        LevelAccessor world = event.getLevel();
        LevelData info = world.m_6106_();
        GameRules rules = info.m_5470_();
        AtomicBoolean dirty = new AtomicBoolean(false);
        if (((Boolean)Config.COMMON.saveGameRules.get()).booleanValue()) {
            Config.COMMON.gameRules.forEach((ruleKey, configValue) -> {
                GameRules.Value val = rules.m_46170_(ruleKey);
                if (val instanceof GameRules.BooleanValue && ((Boolean)((ForgeConfigSpec.BooleanValue)configValue).get()).booleanValue() != ((GameRules.BooleanValue)val).m_46223_()) {
                    ((ForgeConfigSpec.BooleanValue)configValue).set((Object)((GameRules.BooleanValue)val).m_46223_());
                    dirty.set(true);
                } else if (val instanceof GameRules.IntegerValue && ((Integer)((ForgeConfigSpec.IntValue)configValue).get()).intValue() != ((GameRules.IntegerValue)val).m_46288_()) {
                    ((ForgeConfigSpec.IntValue)configValue).set((Object)((GameRules.IntegerValue)val).m_46288_());
                    dirty.set(true);
                }
            });
        }
        if (((Boolean)Config.COMMON.setDifficulty.get()).booleanValue() && !event.getLevel().m_6106_().m_5474_() && Config.COMMON.difficulty.get() != info.m_5472_()) {
            Config.COMMON.difficulty.set((Object)info.m_5472_());
            dirty.set(true);
        }
        if (dirty.get()) {
            Config.commonSpec.save();
        }
    }
}

