/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.mutantmonsters.world.entity.mutant.MutantSnowGolem;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MutantSnowGolemModel
extends EntityModel<MutantSnowGolem> {
    private final List<ModelPart> parts;
    private final ModelPart pelvis;
    private final ModelPart abdomen;
    private final ModelPart chest;
    private final ModelPart head;
    private final ModelPart innerHead;
    private final ModelPart arm1;
    private final ModelPart innerArm1;
    private final ModelPart arm2;
    private final ModelPart innerArm2;
    private final ModelPart foreArm1;
    private final ModelPart innerForeArm1;
    private final ModelPart foreArm2;
    private final ModelPart innerForeArm2;
    private final ModelPart leg1;
    private final ModelPart innerLeg1;
    private final ModelPart leg2;
    private final ModelPart innerLeg2;
    private final ModelPart foreLeg1;
    private final ModelPart innerForeLeg1;
    private final ModelPart foreLeg2;
    private final ModelPart innerForeLeg2;
    private float partialTick;

    public MutantSnowGolemModel(ModelPart modelPart) {
        this.parts = (List)modelPart.m_171331_().collect(ImmutableList.toImmutableList());
        this.pelvis = modelPart.m_171324_("pelvis");
        this.abdomen = this.pelvis.m_171324_("abdomen");
        this.chest = this.abdomen.m_171324_("chest");
        this.head = this.chest.m_171324_("head");
        this.innerHead = this.head.m_171324_("inner_head");
        this.arm1 = this.chest.m_171324_("arm1");
        this.innerArm1 = this.arm1.m_171324_("inner_arm1");
        this.arm2 = this.chest.m_171324_("arm2");
        this.innerArm2 = this.arm2.m_171324_("inner_arm2");
        this.foreArm1 = this.innerArm1.m_171324_("fore_arm1");
        this.innerForeArm1 = this.foreArm1.m_171324_("inner_fore_arm1");
        this.foreArm2 = this.innerArm2.m_171324_("fore_arm2");
        this.innerForeArm2 = this.foreArm2.m_171324_("inner_fore_arm2");
        this.leg1 = this.pelvis.m_171324_("leg1");
        this.innerLeg1 = this.leg1.m_171324_("inner_leg1");
        this.leg2 = this.pelvis.m_171324_("leg2");
        this.innerLeg2 = this.leg2.m_171324_("inner_leg2");
        this.foreLeg1 = this.innerLeg1.m_171324_("fore_leg1");
        this.innerForeLeg1 = this.foreLeg1.m_171324_("inner_fore_leg1");
        this.foreLeg2 = this.innerLeg2.m_171324_("fore_leg2");
        this.innerForeLeg2 = this.foreLeg2.m_171324_("inner_fore_leg2");
    }

    public MutantSnowGolemModel setRenderHeadOnly() {
        this.parts.forEach(t -> {
            t.f_233556_ = true;
        });
        this.innerHead.f_233556_ = false;
        this.head.f_233556_ = false;
        return this;
    }

    public static LayerDefinition createBodyLayer(int textureWidth, int textureHeight) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition pelvis = root.m_171599_("pelvis", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)13.5f, (float)5.0f));
        PartDefinition abdomen = pelvis.m_171599_("abdomen", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f), PartPose.f_171404_);
        PartDefinition chest = abdomen.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(24, 36).m_171481_(-8.0f, -12.0f, -6.0f, 16.0f, 12.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition head = chest.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)-2.0f));
        PartDefinition innerHead = head.m_171599_("inner_head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        innerHead.m_171599_("head_core", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f).m_171514_(80, 46).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(-0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arm1 = chest.m_171599_("arm1", CubeListBuilder.m_171558_().m_171514_(68, 16), PartPose.m_171419_((float)-9.0f, (float)-11.0f, (float)0.0f));
        PartDefinition innerArm1 = arm1.m_171599_("inner_arm1", CubeListBuilder.m_171558_().m_171514_(68, 16).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f), PartPose.f_171404_);
        PartDefinition foreArm1 = innerArm1.m_171599_("fore_arm1", CubeListBuilder.m_171558_().m_171514_(96, 0), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        foreArm1.m_171599_("inner_fore_arm1", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.f_171404_);
        PartDefinition arm2 = chest.m_171599_("arm2", CubeListBuilder.m_171558_().m_171514_(68, 16).m_171480_(), PartPose.m_171419_((float)9.0f, (float)-11.0f, (float)0.0f));
        PartDefinition innerArm2 = arm2.m_171599_("inner_arm2", CubeListBuilder.m_171558_().m_171514_(68, 16).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 10.0f, 5.0f), PartPose.f_171404_);
        PartDefinition foreArm2 = innerArm2.m_171599_("fore_arm2", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171480_(), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        foreArm2.m_171599_("inner_fore_arm2", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f), PartPose.f_171404_);
        PartDefinition leg1 = pelvis.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(88, 18), PartPose.m_171419_((float)-4.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition innerLeg1 = leg1.m_171599_("inner_leg1", CubeListBuilder.m_171558_().m_171514_(88, 18).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.f_171404_);
        PartDefinition foreLeg1 = innerLeg1.m_171599_("fore_leg1", CubeListBuilder.m_171558_().m_171514_(88, 32), PartPose.m_171419_((float)-1.0f, (float)6.0f, (float)-0.0f));
        foreLeg1.m_171599_("inner_fore_leg1", CubeListBuilder.m_171558_().m_171514_(88, 32).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.f_171404_);
        PartDefinition leg2 = pelvis.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(88, 18).m_171480_(), PartPose.m_171419_((float)4.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition innerLeg2 = leg2.m_171599_("inner_leg2", CubeListBuilder.m_171558_().m_171514_(88, 18).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.f_171404_);
        PartDefinition foreLeg2 = innerLeg2.m_171599_("fore_leg2", CubeListBuilder.m_171558_().m_171514_(88, 32).m_171480_(), PartPose.m_171419_((float)1.0f, (float)6.0f, (float)-0.0f));
        foreLeg2.m_171599_("inner_fore_leg2", CubeListBuilder.m_171558_().m_171514_(88, 32).m_171481_(-3.0f, 0.0f, -3.0f, 6.0f, 8.0f, 6.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)textureWidth, (int)textureHeight);
    }

    public void copyPropertiesTo(MutantSnowGolemModel otherModel) {
        for (int i = 0; i < this.parts.size(); ++i) {
            otherModel.parts.get(i).m_104315_(this.parts.get(i));
        }
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.pelvis.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
    }

    public void setupAnim(MutantSnowGolem entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setAngles();
        this.animate(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
    }

    private void setAngles() {
        this.pelvis.f_104201_ = 13.5f;
        this.abdomen.f_104203_ = 0.1308997f;
        this.chest.f_104203_ = 0.1308997f;
        this.chest.f_104204_ = 0.0f;
        this.head.f_104203_ = -0.2617994f;
        this.innerHead.f_104203_ = 0.0f;
        this.innerHead.f_104204_ = 0.0f;
        this.arm1.f_104203_ = -0.31415927f;
        this.arm1.f_104205_ = 0.0f;
        this.innerArm1.f_104203_ = 0.0f;
        this.innerArm1.f_104204_ = 0.5235988f;
        this.innerArm1.f_104205_ = 0.5235988f;
        this.foreArm1.f_104204_ = -0.5235988f;
        this.foreArm1.f_104205_ = -0.2617994f;
        this.innerForeArm1.f_104203_ = -0.5235988f;
        this.arm2.f_104203_ = -0.31415927f;
        this.arm2.f_104205_ = 0.0f;
        this.innerArm2.f_104203_ = 0.0f;
        this.innerArm2.f_104204_ = -0.5235988f;
        this.innerArm2.f_104205_ = -0.5235988f;
        this.foreArm2.f_104204_ = 0.5235988f;
        this.foreArm2.f_104205_ = 0.2617994f;
        this.innerForeArm2.f_104203_ = -0.5235988f;
        this.leg1.f_104203_ = -0.62831855f;
        this.innerLeg1.f_104205_ = 0.5235988f;
        this.foreLeg1.f_104205_ = -0.5235988f;
        this.innerForeLeg1.f_104203_ = 0.69813174f;
        this.leg2.f_104203_ = -0.62831855f;
        this.innerLeg2.f_104205_ = -0.5235988f;
        this.foreLeg2.f_104205_ = 0.5235988f;
        this.innerForeLeg2.f_104203_ = 0.69813174f;
    }

    private void animate(MutantSnowGolem golem, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float temp = 0.5f;
        float walkAnim = Mth.m_14031_((float)(limbSwing * 0.45f)) * limbSwingAmount;
        float walkAnim1 = (Mth.m_14089_((float)((limbSwing - temp) * 0.45f)) + temp) * limbSwingAmount;
        float walkAnim2 = (Mth.m_14089_((float)((limbSwing - temp + (float)Math.PI * 2) * 0.45f)) + temp) * limbSwingAmount;
        float breatheAnim = Mth.m_14031_((float)(ageInTicks * 0.11f));
        float faceYaw = netHeadYaw * (float)Math.PI / 180.0f;
        float facePitch = headPitch * (float)Math.PI / 180.0f;
        if (golem.isThrowing()) {
            this.animateThrow(golem.getThrowingTick());
            float scale = 1.0f - Mth.m_14036_((float)((float)golem.getThrowingTick() / 4.0f), (float)0.0f, (float)1.0f);
            walkAnim *= scale;
        }
        this.innerHead.f_104203_ -= breatheAnim * 0.01f;
        this.chest.f_104203_ -= breatheAnim * 0.01f;
        this.arm1.f_104205_ += breatheAnim * 0.03f;
        this.arm2.f_104205_ -= breatheAnim * 0.03f;
        this.innerHead.f_104203_ += facePitch;
        this.innerHead.f_104204_ += faceYaw;
        this.pelvis.f_104201_ += Math.abs(walkAnim) * 1.5f;
        this.abdomen.f_104203_ += limbSwingAmount * 0.2f;
        this.chest.f_104204_ -= walkAnim * 0.1f;
        this.head.f_104203_ -= limbSwingAmount * 0.2f;
        this.arm1.f_104203_ -= walkAnim * 0.6f;
        this.arm2.f_104203_ += walkAnim * 0.6f;
        this.innerForeArm1.f_104203_ -= walkAnim * 0.2f;
        this.innerForeArm2.f_104203_ += walkAnim * 0.2f;
        this.leg1.f_104203_ += walkAnim1 * 1.1f;
        this.leg2.f_104203_ += walkAnim2 * 1.1f;
        this.innerForeLeg1.f_104203_ += walkAnim * 0.2f;
        this.innerForeLeg2.f_104203_ -= walkAnim * 0.2f;
    }

    private void animateThrow(int fullTick) {
        if (fullTick < 7) {
            float tick = ((float)fullTick + this.partialTick) / 7.0f;
            float f = Mth.m_14031_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += -f * 0.2f;
            this.chest.f_104203_ += -f * 0.4f;
            this.arm1.f_104203_ += -f * 1.6f;
            this.arm1.f_104205_ += f * 0.8f;
            this.arm2.f_104203_ += -f * 1.6f;
            this.arm2.f_104205_ += -f * 0.8f;
        } else if (fullTick < 10) {
            float tick = ((float)(fullTick - 7) + this.partialTick) / 3.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += -f * 0.4f + 0.2f;
            this.chest.f_104203_ += -f * 0.6f + 0.2f;
            this.arm1.f_104203_ += -f * 0.8f - 0.8f;
            this.arm1.f_104205_ += 0.8f;
            this.arm2.f_104203_ += -f * 0.8f - 0.8f;
            this.arm2.f_104205_ += -0.8f;
        } else if (fullTick < 14) {
            this.abdomen.f_104203_ += 0.2f;
            this.chest.f_104203_ += 0.2f;
            this.arm1.f_104203_ += -0.8f;
            this.arm1.f_104205_ += 0.8f;
            this.arm2.f_104203_ += -0.8f;
            this.arm2.f_104205_ += -0.8f;
        } else if (fullTick < 20) {
            float tick = ((float)(fullTick - 14) + this.partialTick) / 6.0f;
            float f = Mth.m_14089_((float)(tick * (float)Math.PI / 2.0f));
            this.abdomen.f_104203_ += f * 0.2f;
            this.chest.f_104203_ += f * 0.2f;
            this.arm1.f_104203_ += -f * 0.8f;
            this.arm1.f_104205_ += f * 0.8f;
            this.arm2.f_104203_ += -f * 0.8f;
            this.arm2.f_104205_ += -f * 0.8f;
        }
    }

    public void prepareMobModel(MutantSnowGolem entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.partialTick = partialTick;
    }

    public void translateArm(boolean leftHanded, PoseStack matrixStackIn) {
        this.pelvis.m_104299_(matrixStackIn);
        this.abdomen.m_104299_(matrixStackIn);
        this.chest.m_104299_(matrixStackIn);
        if (leftHanded) {
            this.arm2.m_104299_(matrixStackIn);
            this.innerArm2.m_104299_(matrixStackIn);
            this.foreArm2.m_104299_(matrixStackIn);
            this.innerForeArm2.m_104299_(matrixStackIn);
        } else {
            this.arm1.m_104299_(matrixStackIn);
            this.innerArm1.m_104299_(matrixStackIn);
            this.foreArm1.m_104299_(matrixStackIn);
            this.innerForeArm1.m_104299_(matrixStackIn);
        }
    }
}

