/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.core;

import fuzs.mutantmonsters.world.entity.ai.goal.TrackSummonerGoal;
import fuzs.mutantmonsters.world.entity.mutant.MutantZombie;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.scores.Scoreboard;

public class ZombieResurrection
extends BlockPos {
    private int tick;

    public ZombieResurrection(Level world, int x, int y, int z) {
        super(x, y, z);
        this.tick = 100 + world.f_46441_.m_188503_(40);
    }

    public ZombieResurrection(Level world, BlockPos pos, int tick) {
        super((Vec3i)pos);
        this.tick = tick;
    }

    public static int getSuitableGround(Level world, int x, int y, int z) {
        return ZombieResurrection.getSuitableGround(world, x, y, z, 4, true);
    }

    public static int getSuitableGround(Level world, int x, int y, int z, int range, boolean checkDay) {
        BlockPos lightPos;
        float f;
        int i = y;
        while (true) {
            if (Math.abs(y - i) > range) {
                return -1;
            }
            BlockPos startPos = new BlockPos(x, i, z);
            BlockPos posUp = startPos.m_7494_();
            BlockState blockState = world.m_8055_(startPos);
            if (blockState.m_204336_(BlockTags.f_13076_)) {
                return -1;
            }
            if ((!checkDay || world.m_6425_(startPos).m_205070_(FluidTags.f_13132_)) && !world.m_6425_(startPos).m_76178_()) break;
            if (world.m_46859_(startPos)) {
                --i;
                continue;
            }
            if (!world.m_46859_(startPos) && world.m_46859_(posUp) && blockState.m_60812_((BlockGetter)world, startPos).m_83281_()) {
                --i;
                break;
            }
            if (world.m_46859_(startPos) || world.m_46859_(posUp) || world.m_8055_(posUp).m_60812_((BlockGetter)world, posUp).m_83281_()) break;
            ++i;
        }
        if (checkDay && world.m_46461_() && (f = world.m_220419_(lightPos = new BlockPos(x, y + 1, z))) > 0.0f && world.m_46861_(lightPos) && world.f_46441_.m_188503_(3) != 0) {
            return -1;
        }
        return i;
    }

    public static EntityType<? extends Zombie> getZombieByLocation(Level world, BlockPos pos) {
        Holder biome = world.m_204166_(pos);
        int chance = world.f_46441_.m_188503_(100);
        if (biome.m_203656_(BiomeTags.f_263796_)) {
            return chance < 80 && world.m_45527_(pos) ? EntityType.f_20458_ : (chance < 1 ? EntityType.f_20530_ : EntityType.f_20501_);
        }
        if (biome.m_203656_(BiomeTags.f_215800_) && world.m_46801_(pos)) {
            return EntityType.f_20562_;
        }
        return chance < 95 ? EntityType.f_20501_ : EntityType.f_20530_;
    }

    public int getTick() {
        return this.tick;
    }

    public boolean update(MutantZombie mutantZombie) {
        Level level = mutantZombie.m_9236_();
        BlockPos abovePos = this.m_7494_();
        if (!level.m_46859_((BlockPos)this) && level.m_46859_(abovePos)) {
            if (mutantZombie.m_217043_().m_188503_(15) == 0) {
                level.m_46796_(2001, abovePos, Block.m_49956_((BlockState)level.m_8055_((BlockPos)this)));
            }
            if (--this.tick <= 0) {
                SpawnGroupData ilivingentitydata;
                Zombie zombieEntity = (Zombie)ZombieResurrection.getZombieByLocation(level, abovePos).m_20615_(level);
                if (level instanceof ServerLevelAccessor && (ilivingentitydata = zombieEntity.m_6518_((ServerLevelAccessor)level, level.m_6436_((BlockPos)this), MobSpawnType.MOB_SUMMONED, null, null)) instanceof Zombie.ZombieGroupData) {
                    new Zombie.ZombieGroupData(((Zombie.ZombieGroupData)ilivingentitydata).f_34354_, false);
                }
                zombieEntity.m_21153_(zombieEntity.m_21233_() * (0.6f + 0.4f * zombieEntity.m_217043_().m_188501_()));
                zombieEntity.m_8032_();
                level.m_46796_(2001, abovePos, Block.m_49956_((BlockState)level.m_8055_((BlockPos)this)));
                if (!level.f_46443_) {
                    zombieEntity.m_20035_(abovePos, mutantZombie.m_146908_(), 0.0f);
                    zombieEntity.f_21345_.m_25352_(0, (Goal)new TrackSummonerGoal(zombieEntity, mutantZombie));
                    zombieEntity.f_21345_.m_25352_(3, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)zombieEntity, 1.0));
                    level.m_7967_((Entity)zombieEntity);
                }
                if (mutantZombie.m_5647_() != null) {
                    Scoreboard scoreboard = level.m_6188_();
                    scoreboard.m_6546_(zombieEntity.m_6302_(), scoreboard.m_83489_(mutantZombie.m_5647_().m_5758_()));
                }
                return false;
            }
            return true;
        }
        return false;
    }
}

