/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.library.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformModHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.library.config.IModIdFormatConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;

public final class ModIdHelper
implements IModIdHelper {
    private final IModIdFormatConfig modIdFormattingConfig;
    private final IIngredientManager ingredientManager;

    public ModIdHelper(IModIdFormatConfig modIdFormattingConfig, IIngredientManager ingredientManager) {
        this.modIdFormattingConfig = modIdFormattingConfig;
        this.ingredientManager = ingredientManager;
    }

    @Override
    public boolean isDisplayingModNameEnabled() {
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        return !modNameFormat.isEmpty();
    }

    @Override
    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, T ingredient, IIngredientHelper<T> ingredientHelper) {
        if (!this.isDisplayingModNameEnabled()) {
            return tooltip;
        }
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && ingredient instanceof ItemStack) {
            return tooltip;
        }
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        ArrayList<Component> tooltipCopy = new ArrayList<Component>(tooltip);
        tooltipCopy.add((Component)Component.m_237113_((String)modName));
        return tooltipCopy;
    }

    @Override
    public <T> Optional<Component> getModNameForTooltip(ITypedIngredient<T> typedIngredient) {
        if (!this.isDisplayingModNameEnabled()) {
            return Optional.empty();
        }
        IIngredientType<T> type = typedIngredient.getType();
        if (this.modIdFormattingConfig.isModNameFormatOverrideActive() && type == VanillaTypes.ITEM_STACK) {
            return Optional.empty();
        }
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        String modId = ingredientHelper.getDisplayModId(ingredient);
        String modName = this.getFormattedModNameForModId(modId);
        return Optional.of(Component.m_237113_((String)modName));
    }

    @Override
    public <T> List<Component> addModNameToIngredientTooltip(List<Component> tooltip, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> type = typedIngredient.getType();
        T ingredient = typedIngredient.getIngredient();
        IIngredientHelper<T> ingredientHelper = this.ingredientManager.getIngredientHelper(type);
        return this.addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = ChatFormatting.m_126649_((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    @Override
    public String getFormattedModNameForModId(String modId) {
        String modName = this.getModNameForModId(modId);
        modName = ModIdHelper.removeChatFormatting(modName);
        String modNameFormat = this.modIdFormattingConfig.getModNameFormat();
        if (!modNameFormat.isEmpty()) {
            if (modNameFormat.contains("%MODNAME%")) {
                return StringUtils.replaceOnce((String)modNameFormat, (String)"%MODNAME%", (String)modName);
            }
            return modNameFormat + modName;
        }
        return modName;
    }

    @Override
    public String getModNameForModId(String modId) {
        IPlatformModHelper modHelper = Services.PLATFORM.getModHelper();
        return modHelper.getModNameForModId(modId);
    }
}

