/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks.blocks;

import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityDummy;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockBlockEntityMaster;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockItem;
import blusunrize.immersiveengineering.api.multiblocks.blocks.registry.MultiblockPartBlock;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract class MultiblockRegistrationBuilder<State extends IMultiblockState, Self extends MultiblockRegistrationBuilder<State, Self>> {
    public static final String DUMMY_BE_SUFFIX = "_dummy";
    public static final String MASTER_BE_SUFFIX = "_master";
    private final IMultiblockLogic<State> logic;
    private final ResourceLocation name;
    private final List<MultiblockRegistration.ExtraComponent<State, ?>> extraComponents = new ArrayList();
    private Supplier<BlockEntityType<? extends MultiblockBlockEntityMaster<State>>> masterBE;
    private Supplier<BlockEntityType<? extends MultiblockBlockEntityDummy<State>>> dummyBE;
    private Supplier<? extends MultiblockPartBlock<State>> block;
    private Supplier<? extends Item> item;
    private boolean mirrorable = true;
    private boolean hasComparatorOutput = false;
    private boolean redstoneInputAware = false;
    private boolean postProcessesShape = false;
    private Supplier<BlockPos> getMasterPosInMB;
    private Function<Level, Vec3i> getSize;
    private MultiblockRegistration.Disassembler disassemble;
    private Function<Level, List<StructureTemplate.StructureBlockInfo>> structure;
    private MultiblockRegistration<State> result;

    public MultiblockRegistrationBuilder(IMultiblockLogic<State> logic, ResourceLocation name) {
        this.logic = logic;
        this.name = name;
    }

    public Self notMirrored() {
        this.mirrorable = false;
        return this.self();
    }

    public Self withComparator() {
        this.hasComparatorOutput = true;
        return this.self();
    }

    public Self postProcessesShape() {
        this.postProcessesShape = true;
        return this.self();
    }

    public Self redstoneAware() {
        this.redstoneInputAware = true;
        return this.self();
    }

    public Self defaultBEs(DeferredRegister<BlockEntityType<?>> register) {
        return this.defaultBEs(RegistrationMethod.fromDeferred(register));
    }

    public Self defaultBEs(RegistrationMethod<BlockEntityType<?>> register) {
        Preconditions.checkState((this.masterBE == null ? 1 : 0) != 0);
        Preconditions.checkState((this.dummyBE == null ? 1 : 0) != 0);
        this.masterBE = register.register(this.name.m_135815_() + MASTER_BE_SUFFIX, () -> this.makeBEType(MultiblockBlockEntityMaster::new));
        this.dummyBE = register.register(this.name.m_135815_() + DUMMY_BE_SUFFIX, () -> this.makeBEType(MultiblockBlockEntityDummy::new));
        return this.self();
    }

    public Self defaultBlock(DeferredRegister<Block> register, DeferredRegister<Item> blockItemRegister, BlockBehaviour.Properties properties) {
        return this.defaultBlock(RegistrationMethod.fromDeferred(register), RegistrationMethod.fromDeferred(blockItemRegister), properties);
    }

    public Self defaultBlock(RegistrationMethod<Block> register, RegistrationMethod<Item> blockItemRegister, BlockBehaviour.Properties properties) {
        return this.customBlock(register, blockItemRegister, (MultiblockRegistration<State> reg) -> {
            if (reg.mirrorable()) {
                return new MultiblockPartBlock.WithMirrorState(properties, reg);
            }
            return new MultiblockPartBlock(properties, reg);
        }, MultiblockItem::new);
    }

    public Self customBlock(DeferredRegister<Block> register, DeferredRegister<Item> blockItemRegister, Function<MultiblockRegistration<State>, ? extends MultiblockPartBlock<State>> make, Function<Block, Item> makeItem) {
        return this.customBlock(RegistrationMethod.fromDeferred(register), RegistrationMethod.fromDeferred(blockItemRegister), make, makeItem);
    }

    public Self customBlock(RegistrationMethod<Block> register, RegistrationMethod<Item> blockItemRegister, Function<MultiblockRegistration<State>, ? extends MultiblockPartBlock<State>> make, Function<Block, Item> makeItem) {
        Preconditions.checkState((this.block == null ? 1 : 0) != 0);
        this.block = register.register(this.name.m_135815_(), () -> (MultiblockPartBlock)((Object)((Object)make.apply(this.result))));
        this.item = blockItemRegister.register(this.name.m_135815_(), () -> (Item)makeItem.apply(this.result.block().get()));
        return this.self();
    }

    public Self structure(Supplier<TemplateMultiblock> structure) {
        Preconditions.checkState((this.getMasterPosInMB == null ? 1 : 0) != 0);
        Preconditions.checkState((this.disassemble == null ? 1 : 0) != 0);
        this.getMasterPosInMB = () -> ((TemplateMultiblock)structure.get()).getMasterFromOriginOffset();
        this.getSize = l -> ((TemplateMultiblock)structure.get()).getSize((Level)l);
        this.disassemble = (level, origin, orientation) -> ((TemplateMultiblock)structure.get()).disassemble(level, origin, orientation.mirrored(), orientation.front());
        this.structure = l -> ((TemplateMultiblock)structure.get()).getStructure((Level)l);
        return this.self();
    }

    public Self component(IMultiblockComponent<State> extraComponent) {
        return this.component(extraComponent, s -> s);
    }

    public <CS> Self component(IMultiblockComponent<CS> extraComponent, IMultiblockComponent.StateWrapper<State, CS> makeState) {
        this.extraComponents.add(new MultiblockRegistration.ExtraComponent<State, CS>(extraComponent, makeState));
        return this.self();
    }

    public <CS, C extends IMultiblockComponent<CS> & IMultiblockComponent.StateWrapper<State, CS>> Self selfWrappingComponent(C extraComponent) {
        return this.component(extraComponent, extraComponent);
    }

    public MultiblockRegistration<State> build() {
        Objects.requireNonNull(this.logic);
        Objects.requireNonNull(this.masterBE);
        Objects.requireNonNull(this.dummyBE);
        Objects.requireNonNull(this.block);
        Objects.requireNonNull(this.item);
        Objects.requireNonNull(this.getMasterPosInMB);
        Objects.requireNonNull(this.getSize);
        Objects.requireNonNull(this.disassemble);
        Objects.requireNonNull(this.structure);
        Preconditions.checkState((this.result == null ? 1 : 0) != 0);
        if (!this.postProcessesShape) {
            try {
                Method postProcessMethod = this.logic.getClass().getMethod("postProcessAbsoluteShape", IMultiblockContext.class, VoxelShape.class, CollisionContext.class, BlockPos.class, ShapeType.class);
                Class<?> declaringClass = postProcessMethod.getDeclaringClass();
                Preconditions.checkState((declaringClass == IMultiblockLogic.class ? 1 : 0) != 0, (String)"Multiblock overrides postProcessAbsoluteShape, but is not marked as post processing! ID: %s", (Object)this.name);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
        this.result = new MultiblockRegistration<State>(this.logic, this.extraComponents, this.masterBE, this.dummyBE, this.block, this.item, this.mirrorable, this.hasComparatorOutput, this.redstoneInputAware, this.postProcessesShape, this.getMasterPosInMB, this.getSize, this.disassemble, this.structure, this.name);
        return this.result;
    }

    private <BE extends BlockEntity> BlockEntityType<? extends BE> makeBEType(BEConstructor<State, BE> construct) {
        MutableObject resultBox = new MutableObject();
        resultBox.setValue((Object)new BlockEntityType((arg_0, arg_1) -> this.lambda$makeBEType$10(construct, (Mutable)resultBox, arg_0, arg_1), Set.of((Block)this.block.get()), null));
        return (BlockEntityType)resultBox.getValue();
    }

    protected abstract Self self();

    private /* synthetic */ BlockEntity lambda$makeBEType$10(BEConstructor construct, Mutable resultBox, BlockPos pos, BlockState state) {
        return construct.make((BlockEntityType)resultBox.getValue(), pos, state, this.result);
    }

    public static interface RegistrationMethod<Base> {
        public <T extends Base> Supplier<T> register(String var1, Supplier<T> var2);

        public static <B> RegistrationMethod<B> fromDeferred(final DeferredRegister<B> register) {
            return new RegistrationMethod<B>(){

                @Override
                public <T extends B> Supplier<T> register(String path, Supplier<T> makeInstance) {
                    return register.register(path, makeInstance);
                }
            };
        }
    }

    private static interface BEConstructor<State extends IMultiblockState, T extends BlockEntity> {
        public T make(BlockEntityType<?> var1, BlockPos var2, BlockState var3, MultiblockRegistration<State> var4);
    }
}

