/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.FurnaceHandler;
import blusunrize.immersiveengineering.common.gui.BlastFurnaceMenu;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;

public class BlastFurnaceScreen
extends IEContainerScreen<BlastFurnaceMenu> {
    private static final ResourceLocation TEXTURE = BlastFurnaceScreen.makeTextureLocation("blast_furnace");

    public BlastFurnaceScreen(BlastFurnaceMenu container, Inventory inventoryPlayer, Component title) {
        super(container, inventoryPlayer, title, TEXTURE);
    }

    public static void drawFlameAndArrow(ContainerData state, GuiGraphics graphics, int leftPos, int topPos, int arrowXOffset) {
        if (FurnaceHandler.StateView.getLastBurnTime(state) > 0) {
            int h = (int)(12.0f * ((float)FurnaceHandler.StateView.getBurnTime(state) / (float)FurnaceHandler.StateView.getLastBurnTime(state)));
            graphics.m_280218_(TEXTURE, leftPos + 56, topPos + 37 + 12 - h, 179, 13 - h, 9, h);
        }
        if (FurnaceHandler.StateView.getMaxProcess(state) > 0) {
            int w = (int)(22.0f * (1.0f - (float)FurnaceHandler.StateView.getProcess(state) / (float)FurnaceHandler.StateView.getMaxProcess(state)));
            graphics.m_280218_(TEXTURE, leftPos + arrowXOffset, topPos + 35, 177, 14, w, 16);
        }
    }

    @Override
    protected void drawBackgroundTexture(GuiGraphics graphics) {
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, 176, this.f_97727_);
    }

    @Override
    protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
        BlastFurnaceScreen.drawFlameAndArrow(((BlastFurnaceMenu)this.f_97732_).state, graphics, this.f_97735_, this.f_97736_, 76);
    }

    public static class Advanced
    extends BlastFurnaceScreen {
        public Advanced(BlastFurnaceMenu container, Inventory inventoryPlayer, Component title) {
            super(container, inventoryPlayer, title);
            this.f_97726_ = 210;
        }

        @Override
        protected void drawContainerBackgroundPre(@Nonnull GuiGraphics graphics, float f, int mx, int my) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 140, this.f_97736_ + 11, 176, 32, 70, 46);
            if (((BlastFurnaceMenu)this.f_97732_).leftHeater.get().booleanValue()) {
                graphics.m_280218_(TEXTURE, this.f_97735_ + 182, this.f_97736_ + 27, 200, 22, 10, 10);
            }
            if (((BlastFurnaceMenu)this.f_97732_).rightHeater.get().booleanValue()) {
                graphics.m_280218_(TEXTURE, this.f_97735_ + 182, this.f_97736_ + 39, 200, 22, 10, 10);
            }
            super.drawContainerBackgroundPre(graphics, f, mx, my);
        }

        @Override
        protected void m_280003_(GuiGraphics graphics, int x, int y) {
            String title = I18n.m_118938_((String)"gui.immersiveengineering.blast_furnace.preheaters", (Object[])new Object[0]);
            int w = this.f_96547_.m_92895_(title) / 2;
            graphics.m_280488_(this.f_96547_, title, 175 - w, 18, 0xAEAEAE);
            graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"gui.immersiveengineering.left", (Object[])new Object[0]), 154, 28, 0xAEAEAE);
            graphics.m_280488_(this.f_96547_, I18n.m_118938_((String)"gui.immersiveengineering.right", (Object[])new Object[0]), 154, 40, 0xAEAEAE);
        }
    }
}

