/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.gui.ClientBlockEntityScreen;
import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonBoolean;
import blusunrize.immersiveengineering.client.gui.elements.GuiButtonState;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ConnectorRedstoneBlockEntity;
import blusunrize.immersiveengineering.common.network.MessageBlockEntitySync;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;

public class RedstoneConnectorScreen
extends ClientBlockEntityScreen<ConnectorRedstoneBlockEntity> {
    private static final ResourceLocation TEXTURE = IEContainerScreen.makeTextureLocation("redstone_configuration");
    private GuiButtonState<IEEnums.IOSideConfig> buttonInOut;
    private GuiButtonBoolean[] colorButtons;

    public RedstoneConnectorScreen(ConnectorRedstoneBlockEntity tileEntity, Component title) {
        super(tileEntity, title);
        this.xSize = 100;
        this.ySize = 120;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.buttonInOut = new GuiButtonState<IEEnums.IOSideConfig>(this.guiLeft + 41, this.guiTop + 20, 18, 18, (Component)Component.m_237119_(), new IEEnums.IOSideConfig[]{IEEnums.IOSideConfig.INPUT, IEEnums.IOSideConfig.OUTPUT}, () -> ((ConnectorRedstoneBlockEntity)this.blockEntity).ioMode.ordinal() - 1, TEXTURE, 176, 0, 1, btn -> this.sendConfig("ioMode", ((IEEnums.IOSideConfig)((Object)((Object)btn.getNextState()))).ordinal()));
        this.m_142416_((GuiEventListener)this.buttonInOut);
        this.colorButtons = new GuiButtonBoolean[16];
        for (int i = 0; i < this.colorButtons.length; ++i) {
            DyeColor color = DyeColor.m_41053_((int)i);
            this.colorButtons[i] = RedstoneConnectorScreen.buildColorButton(this.colorButtons, this.guiLeft + 22 + i % 4 * 14, this.guiTop + 44 + i / 4 * 14, () -> ((ConnectorRedstoneBlockEntity)this.blockEntity).redstoneChannel == color, color, btn -> this.sendConfig("redstoneChannel", color.m_41060_()));
            this.m_142416_((GuiEventListener)this.colorButtons[i]);
        }
    }

    public void sendConfig(String key, int value) {
        CompoundTag message = new CompoundTag();
        message.m_128405_(key, value);
        ImmersiveEngineering.packetHandler.sendToServer((Object)new MessageBlockEntitySync((IEBaseBlockEntity)this.blockEntity, message));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void drawGuiContainerForegroundLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        if (this.buttonInOut.m_198029_()) {
            tooltip.add(Component.m_237115_((String)"gui.immersiveengineering.config.redstone_iomode"));
            tooltip.add(TextUtils.applyFormat(this.buttonInOut.getState().getTextComponent(), ChatFormatting.GRAY));
        }
        for (int i = 0; i < this.colorButtons.length; ++i) {
            if (!this.colorButtons[i].m_198029_()) continue;
            tooltip.add(Component.m_237115_((String)"gui.immersiveengineering.config.redstone_color"));
            tooltip.add(TextUtils.applyFormat((Component)Component.m_237115_((String)("color.minecraft." + DyeColor.m_41053_((int)i).m_41065_())), ChatFormatting.GRAY));
        }
        if (!tooltip.isEmpty()) {
            graphics.m_280677_(this.f_96547_, tooltip, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ClientUtils.mc().f_91066_.f_92092_.isActiveAndMatches(mouseKey)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static GuiButtonBoolean buildColorButton(GuiButtonBoolean[] buttons, int posX, int posY, Supplier<Boolean> active, final DyeColor color, Consumer<GuiButtonBoolean> onClick) {
        return new GuiButtonBoolean(posX, posY, 12, 12, "", active, TEXTURE, 194, 0, 1, btn -> {
            if (((Boolean)btn.getNextState()).booleanValue()) {
                onClick.accept((GuiButtonBoolean)btn);
            }
            for (int j = 0; j < buttons.length; ++j) {
                if (j == color.ordinal() || !((Boolean)buttons[j].getState()).booleanValue()) continue;
                buttons[j].m_5716_(buttons[j].m_252754_(), buttons[j].m_252907_());
            }
        }){

            protected boolean m_7972_(int button) {
                return button == 0 && (Boolean)this.getState() == false;
            }

            @Override
            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                super.m_88315_(graphics, mouseX, mouseY, partialTicks);
                if (this.f_93624_) {
                    int col = color.m_41071_();
                    if (!((Boolean)this.getState()).booleanValue()) {
                        col = ClientUtils.getDarkenedTextColour(col);
                    }
                    col = 0xFF000000 | col;
                    graphics.m_280024_(this.m_252754_() + 3, this.m_252907_() + 3, this.m_252754_() + 9, this.m_252907_() + 9, col, col);
                }
            }
        };
    }
}

