/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.cloth;

import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StripCurtainBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IAdvancedDirectionalBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IColouredBE,
IEBlockInterfaces.IBlockEntityDrop,
IEBlockInterfaces.IBlockBounds {
    public int colour = 0xFFFFFF;
    private int redstoneSignal = 0;
    private boolean strongSignal = false;
    private static final AABB[] bounds = new AABB[]{new AABB(0.0, 0.0, 0.0, 1.0, 0.1875, 0.0625), new AABB(0.0, 0.0, 0.9375, 1.0, 0.1875, 1.0), new AABB(0.0, 0.0, 0.0, 0.0625, 0.1875, 1.0), new AABB(0.9375, 0.0, 0.0, 1.0, 0.1875, 1.0), new AABB(0.0, 0.8125, 0.46875, 1.0, 1.0, 0.53125), new AABB(0.46875, 0.8125, 0.0, 0.53125, 1.0, 1.0)};
    private static final VoxelShape[] shapes = (VoxelShape[])Arrays.stream(bounds).map(Shapes::m_83064_).toArray(VoxelShape[]::new);

    public StripCurtainBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.STRIP_CURTAIN.get(), pos, state);
    }

    @Override
    public void tickServer() {
        if (this.f_58857_.m_46467_() % 4L == (long)((this.m_58899_().m_123341_() ^ this.m_58899_().m_123343_()) & 3)) {
            List entities = this.f_58857_.m_45976_(Entity.class, this.getEntityCollectionBox());
            if (!this.isCeilingAttached() && !entities.isEmpty() && this.redstoneSignal == 0) {
                this.redstoneSignal = 15;
                this.sendRSUpdates();
            }
            if (entities.isEmpty() && this.redstoneSignal != 0) {
                this.redstoneSignal = 0;
                this.sendRSUpdates();
            }
        }
    }

    @Override
    public void onEntityCollision(Level world, Entity entity) {
        if (this.isCeilingAttached() && entity.m_6084_() && this.redstoneSignal == 0 && entity.m_20191_().m_82381_(this.getEntityCollectionBox())) {
            this.redstoneSignal = 15;
            this.sendRSUpdates();
        }
    }

    private void sendRSUpdates() {
        this.m_6596_();
        this.f_58857_.m_46672_(this.m_58899_(), this.m_58900_().m_60734_());
        this.f_58857_.m_46672_(this.m_58899_().m_121945_(this.getStrongSignalSide()), this.m_58900_().m_60734_());
    }

    private Direction getStrongSignalSide() {
        if (this.isCeilingAttached()) {
            return Direction.UP;
        }
        return this.getFacing();
    }

    private AABB getEntityCollectionBox() {
        AABB aabb = bounds[this.isCeilingAttached() ? (this.getFacing().m_122434_() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
        return new AABB(aabb.f_82288_, aabb.f_82289_ - 0.8125, aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, aabb.f_82293_).m_82338_(this.m_58899_());
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        if (!this.strongSignal || side != this.getStrongSignalSide().m_122424_()) {
            return 0;
        }
        return this.getWeakRSOutput(side);
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return 0;
        }
        return this.redstoneSignal;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return false;
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket) {
        this.colour = nbt.m_128451_("colour");
        this.strongSignal = nbt.m_128471_("strongSignal");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        nbt.m_128405_("colour", this.colour);
        nbt.m_128379_("strongSignal", this.strongSignal);
    }

    @Override
    @Nonnull
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return shapes[this.isCeilingAttached() ? (this.getFacing().m_122434_() == Direction.Axis.Z ? 4 : 5) : (this.getFacing().ordinal() - 2) % 4];
    }

    @Override
    @Nonnull
    public Property<Direction> getFacingProperty() {
        return StripCurtainBlock.FACING;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void onDirectionalPlacement(Direction side, float hitX, float hitY, float hitZ, LivingEntity placer) {
        this.setCeilingAttached(side == Direction.DOWN);
    }

    @Override
    public int getRenderColour(int tintIndex) {
        if (tintIndex == 1) {
            return this.colour;
        }
        return 0xFFFFFF;
    }

    @Override
    public void getBlockEntityDrop(LootContext context, Consumer<ItemStack> drop) {
        ItemStack stack = new ItemStack((ItemLike)this.m_58900_().m_60734_(), 1);
        if (this.colour != 0xFFFFFF) {
            ItemNBTHelper.putInt(stack, "colour", this.colour);
        }
        drop.accept(stack);
    }

    @Override
    public void onBEPlaced(BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        if (ItemNBTHelper.hasKey(stack, "colour")) {
            this.colour = ItemNBTHelper.getInt(stack, "colour");
        }
    }

    @Override
    public InteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (!this.f_58857_.f_46443_) {
            this.strongSignal = !this.strongSignal;
            player.m_5661_((Component)Component.m_237115_((String)("chat.immersiveengineering.info.rsControl.strongSignal." + this.strongSignal)), true);
            this.sendRSUpdates();
        }
        return InteractionResult.SUCCESS;
    }

    public boolean isCeilingAttached() {
        return (Boolean)this.m_58900_().m_61143_((Property)StripCurtainBlock.CEILING_ATTACHED);
    }

    public void setCeilingAttached(boolean ceilingAttached) {
        BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)StripCurtainBlock.CEILING_ATTACHED, (Comparable)Boolean.valueOf(ceilingAttached));
        this.getLevelNonnull().m_46597_(this.f_58858_, newState);
    }
}

