/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorBlockEntity;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;

public class CapacitorCreativeBlockEntity
extends CapacitorBlockEntity {
    public CapacitorCreativeBlockEntity(BlockPos pos, BlockState state) {
        super(IEServerConfig.Machines.CapacitorConfig.CREATIVE, pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.sideConfig.put(d, IEEnums.IOSideConfig.OUTPUT);
        }
    }

    @Override
    protected IEnergyStorage makeMainEnergyStorage() {
        return InfiniteEnergyStorage.INSTANCE;
    }

    private static class InfiniteEnergyStorage
    implements IEnergyStorage {
        public static final IEnergyStorage INSTANCE = new InfiniteEnergyStorage();

        private InfiniteEnergyStorage() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return maxReceive;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return maxExtract;
        }

        public int getEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public int getMaxEnergyStored() {
            return Integer.MAX_VALUE;
        }

        public boolean canExtract() {
            return true;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

