/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal.conveyors;

import blusunrize.immersiveengineering.api.tool.conveyor.BasicConveyorType;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.render.conveyor.ExtractConveyorRender;
import blusunrize.immersiveengineering.common.blocks.metal.conveyors.ConveyorBase;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.OptionalDouble;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ExtractConveyor
extends ConveyorBase {
    public static final ResourceLocation NAME = new ResourceLocation("immersiveengineering", "extract");
    public static final IConveyorType<ExtractConveyor> TYPE = new BasicConveyorType<ExtractConveyor>(NAME, true, true, ExtractConveyor::new, () -> new ExtractConveyorRender(texture_on, texture_off));
    private int transferCooldown = -1;
    private int transferTickrate = 8;
    private double extension = -1.0;
    private Rotation relativeExtractDir = Rotation.CLOCKWISE_180;
    private boolean extensionRecursionLock = false;
    private static final VoxelShape ALLOWED_MISSING_SHAPE = Shapes.m_83148_((VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0625, (double)0.0625, (double)0.9375, (double)0.9375, (double)0.9375), (VoxelShape)Shapes.m_83144_(), (BooleanOp)BooleanOp.f_82687_);

    public ExtractConveyor(BlockEntity tile) {
        super(tile);
    }

    public IConveyorType<ExtractConveyor> getType() {
        return TYPE;
    }

    @Override
    public boolean changeConveyorDirection() {
        return false;
    }

    @Override
    public boolean setConveyorDirection(ConveyorHandler.ConveyorDirection dir) {
        return false;
    }

    private OptionalDouble getExtensionIntoBlock(BlockEntity tile) {
        BlockPos neighbour;
        if (tile == null || !tile.m_58898_() || this.extensionRecursionLock) {
            return OptionalDouble.empty();
        }
        this.extensionRecursionLock = true;
        double extend = 0.0;
        Level world = tile.m_58904_();
        if (!world.m_46859_(neighbour = tile.m_58899_().m_121945_(this.getExtractDirection()))) {
            VoxelShape connectedShape;
            VoxelShape projected;
            BlockState connected = world.m_8055_(neighbour);
            BlockEntity connectedTile = world.m_7702_(neighbour);
            if (connectedTile != null && connectedTile.getCapability(ForgeCapabilities.ITEM_HANDLER, this.getExtractDirection().m_122424_()).isPresent() && Shapes.m_83157_((VoxelShape)(projected = (connectedShape = connected.m_60808_((BlockGetter)world, neighbour)).m_83263_(this.getExtractDirection().m_122424_())), (VoxelShape)ALLOWED_MISSING_SHAPE, (BooleanOp)BooleanOp.f_82695_)) {
                double round;
                AABB aabb = connectedShape.m_83215_();
                extend = switch (this.getExtractDirection()) {
                    case Direction.NORTH -> 1.0 - aabb.f_82293_;
                    case Direction.SOUTH -> aabb.f_82290_;
                    case Direction.WEST -> 1.0 - aabb.f_82291_;
                    case Direction.EAST -> aabb.f_82288_;
                    default -> throw new IllegalStateException("Unexpected value: " + this.getExtractDirection());
                };
                if (extend > 0.25) {
                    extend = 0.25;
                }
                if ((round = extend % 0.0625) < extend) {
                    extend = round + 0.0625;
                }
            }
        }
        this.extensionRecursionLock = false;
        return OptionalDouble.of(extend);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void tickServer() {
        BlockPos neighbour;
        Level world;
        if (this.transferCooldown > 0) {
            --this.transferCooldown;
        }
        if (!this.isPowered() && this.transferCooldown <= 0 && !(world = this.getBlockEntity().m_58904_()).m_46859_(neighbour = this.getBlockEntity().m_58899_().m_121945_(this.getExtractDirection()))) {
            LazyOptional<IItemHandler> cap = CapabilityUtils.findItemHandlerAtPos(world, neighbour, this.getExtractDirection().m_122424_(), true);
            cap.ifPresent(itemHandler -> {
                for (int i = 0; i < itemHandler.getSlots(); ++i) {
                    ItemStack extractItem = itemHandler.extractItem(i, 1, true);
                    if (extractItem.m_41619_()) continue;
                    extractItem = itemHandler.extractItem(i, 1, false);
                    ItemEntity entity = new ItemEntity(world, (double)this.getBlockEntity().m_58899_().m_123341_() + 0.5, (double)this.getBlockEntity().m_58899_().m_123342_() + 0.1875, (double)this.getBlockEntity().m_58899_().m_123343_() + 0.5, extractItem);
                    entity.m_20256_(Vec3.f_82478_);
                    world.m_7967_((Entity)entity);
                    this.onItemDeployed(entity);
                    this.transferCooldown = this.transferTickrate;
                    return;
                }
            });
        }
    }

    @Override
    public boolean playerInteraction(Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ, Direction side) {
        if (super.playerInteraction(player, hand, heldItem, hitX, hitY, hitZ, side)) {
            return true;
        }
        if (Utils.isHammer(heldItem) && player.m_6144_()) {
            do {
                this.relativeExtractDir = Rotation.values()[(this.relativeExtractDir.ordinal() + 1) % Rotation.values().length];
            } while (this.relativeExtractDir == Rotation.NONE);
            return true;
        }
        if (Utils.isScrewdriver(heldItem)) {
            if (this.transferTickrate == 4) {
                this.transferTickrate = 8;
            } else if (this.transferTickrate == 8) {
                this.transferTickrate = 16;
            } else if (this.transferTickrate == 16) {
                this.transferTickrate = 20;
            } else if (this.transferTickrate == 20) {
                this.transferTickrate = 4;
            }
            player.m_5661_((Component)Component.m_237110_((String)"chat.immersiveengineering.info.tickrate", (Object[])new Object[]{this.transferTickrate}), true);
            return true;
        }
        return false;
    }

    public double getCurrentExtension() {
        OptionalDouble optValue;
        double extension = this.extension >= 0.0 ? this.extension : ((optValue = this.getExtensionIntoBlock(this.getBlockEntity())).isPresent() ? (this.extension = optValue.getAsDouble()) : 0.0);
        return extension;
    }

    @Override
    public VoxelShape getSelectionShape() {
        VoxelShape extensionShape;
        VoxelShape ret = super.getSelectionShape();
        double extension = this.getCurrentExtension();
        switch (this.getExtractDirection()) {
            case NORTH: {
                VoxelShape voxelShape = Shapes.m_83048_((double)0.0625, (double)0.125, (double)(-extension), (double)0.9375, (double)0.75, (double)(0.375 - extension));
                break;
            }
            case SOUTH: {
                VoxelShape voxelShape = Shapes.m_83048_((double)0.0625, (double)0.125, (double)(0.625 + extension), (double)0.9375, (double)0.75, (double)(1.0 + extension));
                break;
            }
            case WEST: {
                VoxelShape voxelShape = Shapes.m_83048_((double)(-extension), (double)0.125, (double)0.0625, (double)(0.375 - extension), (double)0.75, (double)0.9375);
                break;
            }
            case EAST: {
                VoxelShape voxelShape = Shapes.m_83048_((double)(0.625 + extension), (double)0.125, (double)0.0625, (double)(1.0 + extension), (double)0.75, (double)0.9375);
                break;
            }
            default: {
                VoxelShape voxelShape = extensionShape = null;
            }
        }
        if (extensionShape != null) {
            ret = Shapes.m_83113_((VoxelShape)ret, extensionShape, (BooleanOp)BooleanOp.f_82695_);
        }
        return ret;
    }

    @Override
    public CompoundTag writeConveyorNBT() {
        CompoundTag nbt = super.writeConveyorNBT();
        nbt.m_128405_("transferCooldown", this.transferCooldown);
        nbt.m_128405_("transferTickrate", this.transferTickrate);
        nbt.m_128405_("relativeExtractDir", this.relativeExtractDir.ordinal());
        return nbt;
    }

    @Override
    public void readConveyorNBT(CompoundTag nbt) {
        super.readConveyorNBT(nbt);
        this.transferCooldown = nbt.m_128451_("transferCooldown");
        this.transferTickrate = nbt.m_128451_("transferTickrate");
        this.relativeExtractDir = Rotation.values()[nbt.m_128451_("relativeExtractDir")];
        if (this.relativeExtractDir == Rotation.NONE) {
            this.relativeExtractDir = Rotation.CLOCKWISE_180;
        }
    }

    public Direction getExtractDirection() {
        return this.relativeExtractDir.m_55954_(this.getFacing());
    }
}

