/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.client.utils.TextUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.interfaces.MBOverlayText;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.LayeredComparatorOutput;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SheetmetalTankLogic
implements IServerTickableComponent<State>,
MBOverlayText<State> {
    public static final BlockPos IO_POS = new BlockPos(1, 0, 1);
    private static final BlockPos INPUT_POS = new BlockPos(1, 4, 1);

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        state.comparatorHelper.update(context, state.tank.getFluidAmount());
        if (!state.rsState.isEnabled(context) || state.tank.isEmpty()) {
            return;
        }
        for (CapabilityReference<IFluidHandler> outputRef : state.outputs) {
            int accepted;
            int outSize = Math.min(1000, state.tank.getFluidAmount());
            FluidStack out = Utils.copyFluidStackWithAmount(state.tank.getFluid(), outSize, false);
            IFluidHandler output = outputRef.getNullable();
            if (output == null || (accepted = output.fill(out, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.getAmount(), accepted), false), IFluidHandler.FluidAction.EXECUTE);
            state.tank.drain(drained, IFluidHandler.FluidAction.EXECUTE);
            context.markMasterDirty();
            context.requestMasterBESync();
            if (!state.tank.isEmpty()) continue;
            break;
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (IO_POS.equals((Object)position.posInMultiblock())) {
                return ctx.getState().ioHandler.cast(ctx);
            }
            if (INPUT_POS.equals((Object)position.posInMultiblock())) {
                return ctx.getState().inputHandler.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    @Nullable
    public List<Component> getOverlayText(State state, Player player, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.m_21120_(InteractionHand.MAIN_HAND))) {
            return List.of(TextUtils.formatFluidStack(state.tank.getFluid()));
        }
        return null;
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return pos -> {
            if (pos.m_123341_() % 2 == 0 && pos.m_123342_() == 0 && pos.m_123343_() % 2 == 0) {
                return Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
            }
            return Shapes.m_83144_();
        };
    }

    @Override
    public InteractionResult click(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Player player, InteractionHand hand, BlockHitResult absoluteHit, boolean isClient) {
        if (FluidUtils.interactWithFluidHandler(player, hand, (IFluidHandler)ctx.getState().tank)) {
            ctx.markDirtyAndSync();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static class State
    implements IMultiblockState {
        public final FluidTank tank = new FluidTank(512000);
        private final LayeredComparatorOutput<IMultiblockContext<?>> comparatorHelper;
        private final List<CapabilityReference<IFluidHandler>> outputs;
        private final StoredCapability<IFluidHandler> inputHandler;
        private final StoredCapability<IFluidHandler> ioHandler;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.disabledByDefault();

        public State(IInitialMultiblockContext<State> capabilitySource) {
            this.comparatorHelper = LayeredComparatorOutput.makeForSiloLike(this.tank.getCapacity(), 4);
            ImmutableList.Builder outputBuilder = ImmutableList.builder();
            for (RelativeBlockFace face : RelativeBlockFace.values()) {
                if (face == RelativeBlockFace.DOWN) continue;
                BlockPos neighbor = face.offsetRelative(IO_POS, -1);
                outputBuilder.add(capabilitySource.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, neighbor, face));
            }
            this.outputs = outputBuilder.build();
            Runnable changedAndSync = () -> {
                capabilitySource.getSyncRunnable().run();
                capabilitySource.getMarkDirtyRunnable().run();
            };
            this.inputHandler = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler((IFluidTank)this.tank, false, true, changedAndSync));
            this.ioHandler = new StoredCapability<ArrayFluidHandler>(new ArrayFluidHandler((IFluidTank)this.tank, true, true, changedAndSync));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            this.writeSaveNBT(nbt);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.readSaveNBT(nbt);
        }
    }
}

