/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.SqueezerRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.fluid.FluidUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.StoredCapability;
import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInMachine;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.SqueezerShapes;
import blusunrize.immersiveengineering.common.fluids.ArrayFluidHandler;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.SlotwiseItemHandler;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class SqueezerLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos REDSTONE_POS = new BlockPos(2, 1, 2);
    private static final MultiblockFace ITEM_OUTPUT = new MultiblockFace(2, 1, 1, RelativeBlockFace.RIGHT);
    private static final MultiblockFace FLUID_OUTPUT = new MultiblockFace(3, 0, 1, RelativeBlockFace.RIGHT);
    private static final CapabilityPosition ITEM_OUTPUT_CAP = CapabilityPosition.opposing(ITEM_OUTPUT);
    private static final CapabilityPosition FLUID_OUTPUT_CAP = CapabilityPosition.opposing(FLUID_OUTPUT);
    private static final BlockPos ITEM_INPUT = new BlockPos(0, 1, 0);
    private static final CapabilityPosition ENERGY_POS = new CapabilityPosition(0, 1, 2, RelativeBlockFace.UP);
    public static final int NUM_SLOTS = 11;
    public static final int NUM_INPUT_SLOTS = 8;
    public static final int OUTPUT_SLOT = 8;
    public static final int TANK_CAPACITY = 24000;
    public static final int ENERGY_CAPACITY = 16000;

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean active = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (active != state.active) {
            state.active = active;
            context.requestMasterBESync();
        }
        this.enqueueProcesses(state, context.getLevel().getRawLevel());
        if (context.getLevel().shouldTickModulo(8)) {
            this.handleItemOutput(context);
        }
        FluidUtils.multiblockFluidOutput(state.fluidOutput, state.tank, 9, 10, state.inventory);
    }

    private void enqueueProcesses(State state, Level level) {
        int n;
        if (state.energy.getEnergyStored() <= 0 || state.processor.getQueueSize() >= state.processor.getMaxQueueSize()) {
            return;
        }
        int[] usedInvSlots = new int[8];
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof MultiblockProcessInMachine)) continue;
            int[] nArray = ((MultiblockProcessInMachine)process).getInputSlots();
            n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int i2;
                int n2 = i2 = nArray[i];
                usedInvSlots[n2] = usedInvSlots[n2] + 1;
            }
        }
        Integer[] preferredSlots = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7};
        Arrays.sort(preferredSlots, 0, 8, Comparator.comparingInt(arg0 -> usedInvSlots[arg0]));
        Integer[] integerArray = preferredSlots;
        int n3 = integerArray.length;
        for (n = 0; n < n3; ++n) {
            int slot = integerArray[n];
            ItemStack stack = state.inventory.getStackInSlot(slot);
            if (stack.m_41613_() <= usedInvSlots[slot]) continue;
            stack = stack.m_41777_();
            stack.m_41774_(usedInvSlots[slot]);
            SqueezerRecipe recipe = SqueezerRecipe.findRecipe(level, stack);
            if (recipe == null) continue;
            state.processor.addProcessToQueue(new MultiblockProcessInMachine<SqueezerRecipe>(recipe, slot), level, false);
        }
    }

    private void handleItemOutput(IMultiblockContext<State> ctx) {
        State state = ctx.getState();
        ItemStack fullOutputStack = state.inventory.getStackInSlot(8);
        if (fullOutputStack.m_41619_()) {
            return;
        }
        ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)fullOutputStack, (int)1);
        ItemStack remaining = Utils.insertStackIntoInventory(state.itemOutput, stack, false);
        if (remaining.m_41619_()) {
            fullOutputStack.m_41774_(1);
            ctx.markMasterDirty();
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (!state.active && (double)state.animation_piston < 0.6875) {
            state.animation_piston = Math.min(0.6875f, state.animation_piston + 0.03125f);
        } else if (state.active) {
            state.animation_piston = state.animation_down ? Math.max(0.0f, state.animation_piston - 0.03125f) : Math.min(0.6875f, state.animation_piston + 0.03125f);
            if (state.animation_piston <= 0.0f && state.animation_down) {
                state.animation_down = false;
            } else if ((double)state.animation_piston >= 0.6875 && !state.animation_down) {
                state.animation_down = true;
            }
        }
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public <T> LazyOptional<T> getCapability(IMultiblockContext<State> ctx, CapabilityPosition position, Capability<T> cap) {
        State state = ctx.getState();
        if (cap == ForgeCapabilities.ENERGY && ENERGY_POS.equalsOrNullFace(position)) {
            return state.energyCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER && FLUID_OUTPUT_CAP.equalsOrNullFace(position)) {
            return state.fluidOutputCap.cast(ctx);
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (ITEM_INPUT.equals((Object)position.posInMultiblock())) {
                return state.itemInputCap.cast(ctx);
            }
            if (ITEM_OUTPUT_CAP.equals(position)) {
                return state.itemOutputCap.cast(ctx);
            }
        }
        return LazyOptional.empty();
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandler)state.inventory, drop);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return SqueezerShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(state -> Utils.calcRedstoneFromInventory(8, (IItemHandler)state.inventory), REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<SqueezerRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(16000);
        private final FluidTank tank = new FluidTank(24000);
        private final SlotwiseItemHandler inventory;
        private final MultiblockProcessor.InMachineProcessor<SqueezerRecipe> processor;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        public boolean active;
        public float animation_piston = 0.0f;
        public boolean animation_down = true;
        private final CapabilityReference<IItemHandler> itemOutput;
        private final CapabilityReference<IFluidHandler> fluidOutput;
        private final StoredCapability<IEnergyStorage> energyCap;
        private final StoredCapability<IFluidHandler> fluidOutputCap;
        private final StoredCapability<IItemHandler> itemInputCap;
        private final StoredCapability<IItemHandler> itemOutputCap;

        public State(IInitialMultiblockContext<State> ctx) {
            Runnable markDirty = ctx.getMarkDirtyRunnable();
            this.inventory = SlotwiseItemHandler.makeWithGroups(List.of(new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.ANY_INPUT, 8), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.FLUID_INPUT, 1), new SlotwiseItemHandler.IOConstraintGroup(SlotwiseItemHandler.IOConstraint.OUTPUT, 1)), markDirty);
            this.processor = new MultiblockProcessor.InMachineProcessor<SqueezerRecipe>(8, 0.0f, 8, markDirty, SqueezerRecipe.RECIPES::getById);
            this.itemOutput = ctx.getCapabilityAt(ForgeCapabilities.ITEM_HANDLER, ITEM_OUTPUT);
            this.fluidOutput = ctx.getCapabilityAt(ForgeCapabilities.FLUID_HANDLER, FLUID_OUTPUT);
            this.energyCap = new StoredCapability<AveragingEnergyStorage>(this.energy);
            this.fluidOutputCap = new StoredCapability<ArrayFluidHandler>(ArrayFluidHandler.drainOnly((IFluidTank)this.tank, markDirty));
            this.itemInputCap = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(0, 8)));
            this.itemOutputCap = new StoredCapability<WrappingItemHandler>(new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(8, 9)));
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt) {
            nbt.m_128365_("energy", this.energy.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            nbt.m_128365_("inventory", this.inventory.serializeNBT());
            nbt.m_128365_("processor", this.processor.toNBT());
        }

        @Override
        public void readSaveNBT(CompoundTag nbt) {
            this.energy.deserializeNBT(nbt.m_128423_("energy"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.processor.fromNBT(nbt.m_128423_("processor"), MultiblockProcessInMachine::new);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt) {
            nbt.m_128379_("active", this.active);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt) {
            this.active = nbt.m_128471_("active");
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        @Override
        public IItemHandlerModifiable getInventory() {
            return this.inventory.getRawHandler();
        }

        @Override
        public int[] getOutputTanks() {
            return new int[]{0};
        }

        @Override
        public IFluidTank[] getInternalTanks() {
            return new IFluidTank[]{this.tank};
        }

        public FluidTank getTank() {
            return this.tank;
        }

        @Override
        public int[] getOutputSlots() {
            return new int[]{8};
        }
    }
}

