/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class GeneratedListSerializer
extends IERecipeSerializer<GeneratedListRecipe<?, ?>> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((ItemLike)IEItems.Misc.WIRE_COILS.get(WireType.COPPER));
    }

    @Override
    public GeneratedListRecipe<?, ?> readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        return GeneratedListRecipe.from(recipeId);
    }

    @Nullable
    public GeneratedListRecipe<?, ?> fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        int length = buffer.m_130242_();
        ArrayList<IESerializableRecipe> subRecipes = new ArrayList<IESerializableRecipe>(length);
        ResourceLocation recipeCategory = buffer.m_130281_();
        RecipeSerializer deserializer = Objects.requireNonNull((RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(recipeCategory));
        for (int i = 0; i < length; ++i) {
            ResourceLocation recipeName = buffer.m_130281_();
            Recipe subRecipe = deserializer.m_8005_(recipeName, buffer);
            subRecipes.add((IESerializableRecipe)subRecipe);
        }
        return GeneratedListRecipe.resolved(recipeId, subRecipes);
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull GeneratedListRecipe<?, ?> recipe) {
        List<IESerializableRecipe> recipes = recipe.getSubRecipes();
        buffer.m_130130_(recipes.size());
        buffer.m_130085_(recipe.getSubSerializer());
        for (IESerializableRecipe r : recipes) {
            buffer.m_130085_(r.m_6423_());
            ((IERecipeSerializer)r.m_7707_()).m_6178_(buffer, r);
        }
    }
}

