/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class MineralArgument
implements ArgumentType<MineralMix> {
    public static final DynamicCommandExceptionType invalidVein = new DynamicCommandExceptionType(input -> Component.m_237110_((String)"chat.immersiveengineering.command.mineral.invalid", (Object[])new Object[]{input}));

    public MineralMix parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readQuotedString();
        for (MineralMix mm : this.getStaticMinerals()) {
            if (!mm.m_6423_().toString().equalsIgnoreCase(name)) continue;
            return mm;
        }
        throw invalidVein.create((Object)name);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(this.getStaticMinerals().stream().map(mix -> "\"" + mix.m_6423_() + "\""), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        ArrayList<String> ret = new ArrayList<String>();
        for (MineralMix mix : this.getStaticMinerals()) {
            ret.add("\"" + mix.m_6423_() + "\"");
            if (ret.size() <= 5) continue;
            break;
        }
        return ret;
    }

    private Collection<MineralMix> getStaticMinerals() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Level level = server == null ? ImmersiveEngineering.proxy.getClientWorld() : server.m_129783_();
        return MineralMix.RECIPES.getRecipes(level);
    }
}

