/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.math;

import malte0811.modelsplitter.math.Vec3d;

public record EpsilonMath(double epsilon) {
    public Sign sign(double firstProduct) {
        if (firstProduct < -this.epsilon) {
            return Sign.NEGATIVE;
        }
        if (firstProduct > this.epsilon) {
            return Sign.POSITIVE;
        }
        return Sign.ZERO;
    }

    public boolean areSame(Vec3d a, Vec3d b) {
        Vec3d diff = a.subtract(b);
        return diff.lengthSquared() < this.epsilon * this.epsilon;
    }

    public int floor(double in) {
        return (int)Math.floor(in + this.epsilon);
    }

    public int ceil(double in) {
        return (int)Math.ceil(in - this.epsilon);
    }

    public static enum Sign {
        POSITIVE,
        ZERO,
        NEGATIVE;


        public Sign invert() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case POSITIVE -> NEGATIVE;
                case ZERO -> ZERO;
                case NEGATIVE -> POSITIVE;
            };
        }
    }
}

