/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc.lootmanager;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class EndRemasteredDedicatedLoot {
    public static boolean isEndRemasteredOn = false;
    public static final Map<ResourceLocation, ResourceLocation> END_REMASTERED_DEDICATED_TABLE_IMPORTS = EndRemasteredDedicatedLoot.createEndRemasteredMap();

    private EndRemasteredDedicatedLoot() {
    }

    private static Map<ResourceLocation, ResourceLocation> createEndRemasteredMap() {
        HashMap<ResourceLocation, ResourceLocation> tableMap = new HashMap<ResourceLocation, ResourceLocation>();
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/birch"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/ocean"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/savanna"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/stone"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/swamp"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/dark_forest"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/taiga"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/stone"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/mushroom"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/grassy"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/igloos/mangrove"), new ResourceLocation("endrem:minecraft/chests/abandoned_mineshaft"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/badlands"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/dark_forest"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/deep"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/desert"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/jungle"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/icy"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/mushroom"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/ocean"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/snow"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/swamp"), new ResourceLocation("endrem:minecraft/chests/simple_dungeon"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/fortresses/jungle_shrine"), new ResourceLocation("endrem:minecraft/chests/jungle_temple"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/jungle"), new ResourceLocation("endrem:minecraft/chests/jungle_temple"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/jungle"), new ResourceLocation("endrem:minecraft/chests/jungle_temple"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/flower_forest"), new ResourceLocation("endrem:minecraft/chests/jungle_temple"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/desert"), new ResourceLocation("endrem:minecraft/chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/mushroom"), new ResourceLocation("endrem:minecraft/chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/giant_tree_taiga"), new ResourceLocation("endrem:minecraft/chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/dark_forest"), new ResourceLocation("endrem:minecraft/chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/badlands"), new ResourceLocation("endrem:minecraft/chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/ocean"), new ResourceLocation("endrem:minecraft/chests/desert_pyramid"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/icy"), new ResourceLocation("endrem:minecraft/chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/snowy"), new ResourceLocation("endrem:minecraft/chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/pyramids/icy"), new ResourceLocation("endrem:minecraft/chests/igloo_chest"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/badlands"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/birch"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/desert"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/giant_tree_taiga"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/icy"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/jungle"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/oak"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/snowy"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/taiga"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/mangrove"), new ResourceLocation("endrem:minecraft/chests/pillager_outpost"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/crimson"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/nether_brick"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/outposts/warped"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/dungeons/nether"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/crimson"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/nether"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/mineshafts/warped"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/basalt"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/crimson"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/soul"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/wasteland"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/temples/warped"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/temples/warped"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "trapped_chests/pyramids/nether"), new ResourceLocation("endrem:minecraft/chests/nether_bridge"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/crimson/treasure"), new ResourceLocation("endrem:minecraft/chests/buried_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/nether_bricks/treasure"), new ResourceLocation("endrem:minecraft/chests/buried_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/shipwrecks/warped/treasure"), new ResourceLocation("endrem:minecraft/chests/buried_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/treasure"), new ResourceLocation("endrem:minecraft/chests/buried_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/bridge"), new ResourceLocation("endrem:minecraft/chests/buried_treasure"));
        tableMap.put(new ResourceLocation("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), new ResourceLocation("endrem:minecraft/chests/buried_treasure"));
        return tableMap;
    }

    public static void checkLoottables(MinecraftServer minecraftServer) {
        if (isEndRemasteredOn) {
            boolean invalidLootTableFound = false;
            for (Map.Entry<ResourceLocation, ResourceLocation> entry : END_REMASTERED_DEDICATED_TABLE_IMPORTS.entrySet()) {
                if (!GeneralUtils.isInvalidLootTableFound(minecraftServer, entry)) continue;
                invalidLootTableFound = true;
            }
            if (invalidLootTableFound) {
                RepurposedStructures.LOGGER.error("Unknown import/target loot tables found for Repurposed Structures. See above logs and report to TelepathicGrunt please.");
            }
        }
    }
}

