/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket;

import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.datagen.conditions.EnchantedCondition;
import com.brokenkeyboard.simplemusket.datagen.conditions.HellfireCondition;
import com.brokenkeyboard.simplemusket.entity.BulletEntityRenderer;
import com.brokenkeyboard.simplemusket.entity.HatModel;
import com.brokenkeyboard.simplemusket.entity.MusketPillager;
import com.brokenkeyboard.simplemusket.entity.MusketPillagerRenderer;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import com.brokenkeyboard.simplemusket.network.Network;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class Events {

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="simplemusket", value={Dist.CLIENT})
    public static class RegisterModels {
        @SubscribeEvent
        public static void registerModels(ModelEvent.RegisterAdditional event) {
            event.register((ResourceLocation)new ModelResourceLocation("simplemusket", "musket_inventory", "inventory"));
        }

        @SubscribeEvent
        public static void armorLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("simplemusket", "musket_pillager"), "overlay"), HatModel::createBodyLayer);
        }
    }

    @Mod.EventBusSubscriber(modid="simplemusket", value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void onRenderLivingEventPre(RenderLivingEvent.Pre<Player, PlayerModel<Player>> event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            InteractionHand hand = player.m_7655_();
            if (player.m_21120_(hand).m_41720_() instanceof MusketItem) {
                HumanoidModel model = (HumanoidModel)event.getRenderer().m_7200_();
                if (MusketItem.hasAmmo(player.m_21120_(hand))) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        model.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    } else {
                        model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
                    }
                } else if (player.m_6117_() && !MusketItem.hasAmmo(player.m_21120_(hand))) {
                    if (hand == InteractionHand.MAIN_HAND) {
                        model.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    } else {
                        model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                    }
                }
            }
        }

        @SubscribeEvent
        public static void renderHandEvent(RenderHandEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            InteractionHand hand = player.m_7655_();
            if (player.m_21120_(hand).m_41720_() instanceof MusketItem) {
                if (event.getHand() == InteractionHand.OFF_HAND && hand == InteractionHand.MAIN_HAND && player.m_6117_()) {
                    event.setCanceled(true);
                } else if (event.getHand() == InteractionHand.MAIN_HAND && hand == InteractionHand.OFF_HAND && player.m_6117_()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="simplemusket")
    public static class CommonEvents {
        @SubscribeEvent
        public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof AbstractVillager) {
                AbstractVillager villager = (AbstractVillager)entity;
                villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, MusketPillager.class, 8.0f, 0.6, 0.6));
            }
        }

        @SubscribeEvent
        public static void addTrades(VillagerTradesEvent event) {
            if (event.getType() != VillagerProfession.f_35599_) {
                return;
            }
            Int2ObjectMap trades = event.getTrades();
            ((List)trades.get(3)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)ModRegistry.MUSKET), 3, 10, 0.05f));
            ((List)trades.get(3)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)ModRegistry.CARTRIDGE, 4), 16, 1, 0.05f));
            ((List)trades.get(3)).add((trader, rand) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 3), new ItemStack((ItemLike)ModRegistry.ENCHANTED_CARTRIDGE, 4), 16, 1, 0.05f));
        }
    }

    @Mod.EventBusSubscriber(modid="simplemusket", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onRegisterEvent(RegisterEvent event) {
            event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, helper -> {
                CraftingHelper.register(EnchantedCondition.SERIALIZER);
                CraftingHelper.register(HellfireCondition.SERIALIZER);
            });
        }

        @SubscribeEvent
        public static void registerRenders(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(ModRegistry.BULLET_ENTITY, BulletEntityRenderer::new);
            event.registerEntityRenderer(ModRegistry.GUNSLINGER, MusketPillagerRenderer::new);
        }

        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(Network::register);
            Raid.RaiderType.create((String)ModRegistry.GUNSLINGER.toString(), ModRegistry.GUNSLINGER, (int[])new int[]{0, 0, 0, 0, 0, 1, 1, 2});
            ModRegistry.registerSensorGoal();
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(ModRegistry::registerItemProperties);
        }

        @SubscribeEvent
        public static void onAttributeCreate(EntityAttributeCreationEvent event) {
            event.put(ModRegistry.GUNSLINGER, MusketPillager.createAttributes().m_22265_());
        }

        @SubscribeEvent
        public static void spawnRegister(SpawnPlacementRegisterEvent event) {
            event.register(ModRegistry.GUNSLINGER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_, SpawnPlacementRegisterEvent.Operation.OR);
        }
    }
}

