/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket;

import com.brokenkeyboard.simplemusket.Config;
import com.brokenkeyboard.simplemusket.enchantment.FirepowerEnchantment;
import com.brokenkeyboard.simplemusket.enchantment.LongshotEnchantment;
import com.brokenkeyboard.simplemusket.enchantment.RepeatingEnchantment;
import com.brokenkeyboard.simplemusket.entity.BulletEntity;
import com.brokenkeyboard.simplemusket.entity.MusketPillager;
import com.brokenkeyboard.simplemusket.item.BulletItem;
import com.brokenkeyboard.simplemusket.item.EnchCartridgeRecipe;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import com.brokenkeyboard.simplemusket.mixin.VillagerHostilesSensorAccessor;
import com.brokenkeyboard.simplemusket.platform.Services;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class ModRegistry {
    public static final Map<ResourceLocation, EntityType<?>> ENTITIES = new HashMap();
    public static final Map<ResourceLocation, Item> ITEMS = new HashMap<ResourceLocation, Item>();
    public static final Map<ResourceLocation, Enchantment> ENCHANTMENTS = new HashMap<ResourceLocation, Enchantment>();
    public static final Map<ResourceLocation, MobEffect> EFFECTS = new HashMap<ResourceLocation, MobEffect>();
    public static final Map<ResourceLocation, SoundEvent> SOUNDS = new HashMap<ResourceLocation, SoundEvent>();
    public static final EntityType<? extends BulletEntity> BULLET_ENTITY = ModRegistry.addEntity(new ResourceLocation("simplemusket", "bullet"), Services.PLATFORM.createBulletEntity());
    public static final EntityType<? extends MusketPillager> GUNSLINGER = ModRegistry.addEntity(new ResourceLocation("simplemusket", "musket_pillager"), EntityType.Builder.m_20704_(MusketPillager::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 1.95f).m_20720_().m_20702_(8).m_20712_("musket_pillager"));
    public static final Item MUSKET = ModRegistry.addItem(new ResourceLocation("simplemusket", "musket"), (Item)new MusketItem(new Item.Properties()));
    public static final Item CARTRIDGE = ModRegistry.addItem(new ResourceLocation("simplemusket", "cartridge"), new BulletItem(6.0f));
    public static final Item HELLFIRE_CARTRIDGE = ModRegistry.addItem(new ResourceLocation("simplemusket", "hellfire_cartridge"), new BulletItem(6.0f));
    public static final Item ENCHANTED_CARTRIDGE = ModRegistry.addItem(new ResourceLocation("simplemusket", "enchanted_cartridge"), new BulletItem(7.5f));
    public static final Item GUNSLINGER_EGG = ModRegistry.addItem(new ResourceLocation("simplemusket", "musket_pillager_spawn_egg"), (Item)new SpawnEggItem(GUNSLINGER, 0x959B9B, 5258034, new Item.Properties()));
    public static final RecipeSerializer<EnchCartridgeRecipe> ENCH_CARTRIDGE_CRAFTING = Services.PLATFORM.createRecipeSerializer("crafting_special_enchanted_cartidge", new SimpleCraftingRecipeSerializer(EnchCartridgeRecipe::new));
    public static final EnchantmentCategory FIREARM = Services.PLATFORM.musketCategory();
    public static final Enchantment FIREPOWER = ModRegistry.addEnchant(new ResourceLocation("simplemusket", "firepower"), new FirepowerEnchantment(FIREARM, EquipmentSlot.MAINHAND));
    public static final Enchantment LONGSHOT = ModRegistry.addEnchant(new ResourceLocation("simplemusket", "longshot"), new LongshotEnchantment(FIREARM, EquipmentSlot.MAINHAND));
    public static final Enchantment REPEATING = ModRegistry.addEnchant(new ResourceLocation("simplemusket", "repeating"), new RepeatingEnchantment(FIREARM, EquipmentSlot.MAINHAND));
    public static final MobEffect ARMOR_DECREASE = ModRegistry.addEffect(new ResourceLocation("simplemusket", "armor_decrease"), new ArmorDecreaseEffect(MobEffectCategory.HARMFUL, 4595487).m_19472_(Attributes.f_22284_, "E8BA6690-8212-421F-8FCF-69A88DEBA4F8", -0.25, AttributeModifier.Operation.MULTIPLY_BASE));
    public static final SoundEvent MUSKET_LOAD_0 = ModRegistry.addSound(new ResourceLocation("simplemusket", "musket_load0"), SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("simplemusket", "musket_load0")));
    public static final SoundEvent MUSKET_LOAD_1 = ModRegistry.addSound(new ResourceLocation("simplemusket", "musket_load1"), SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("simplemusket", "musket_load1")));
    public static final SoundEvent MUSKET_READY = ModRegistry.addSound(new ResourceLocation("simplemusket", "musket_ready"), SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("simplemusket", "musket_ready")));
    public static final SoundEvent MUSKET_FIRE = ModRegistry.addSound(new ResourceLocation("simplemusket", "musket_fire"), SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("simplemusket", "musket_fire")));
    public static final Predicate<LivingEntity> AIMING_MUSKET = entity -> MusketItem.isLoaded(entity.m_21211_()) && entity.m_21211_().m_41779_() - entity.m_21212_() > (Integer)Config.AIM_TIME.get();

    public static EntityType<?> addEntity(ResourceLocation location, EntityType<?> type) {
        ENTITIES.put(location, type);
        return type;
    }

    public static Item addItem(ResourceLocation location, Item item) {
        ITEMS.put(location, item);
        return item;
    }

    public static Enchantment addEnchant(ResourceLocation location, Enchantment enchantment) {
        ENCHANTMENTS.put(location, enchantment);
        return enchantment;
    }

    public static MobEffect addEffect(ResourceLocation location, MobEffect effect) {
        EFFECTS.put(location, effect);
        return effect;
    }

    public static SoundEvent addSound(ResourceLocation location, SoundEvent sound) {
        SOUNDS.put(location, sound);
        return sound;
    }

    public static void registerEntity(BiConsumer<ResourceLocation, EntityType<?>> consumer) {
        for (Map.Entry<ResourceLocation, EntityType<?>> entry : ENTITIES.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public static void registerItems(BiConsumer<ResourceLocation, Item> consumer) {
        for (Map.Entry<ResourceLocation, Item> entry : ITEMS.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public static void registerEnchants(BiConsumer<ResourceLocation, Enchantment> consumer) {
        for (Map.Entry<ResourceLocation, Enchantment> entry : ENCHANTMENTS.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public static void registerEffects(BiConsumer<ResourceLocation, MobEffect> consumer) {
        for (Map.Entry<ResourceLocation, MobEffect> entry : EFFECTS.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public static void registerSounds(BiConsumer<ResourceLocation, SoundEvent> consumer) {
        for (Map.Entry<ResourceLocation, SoundEvent> entry : SOUNDS.entrySet()) {
            consumer.accept(entry.getKey(), entry.getValue());
        }
    }

    public static void registerItemProperties() {
        ItemProperties.register((Item)MUSKET, (ResourceLocation)new ResourceLocation("simplemusket", "loading"), (stack, world, living, id) -> living != null && living.m_21211_() == stack && living.m_6117_() && !MusketItem.isLoaded(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)MUSKET, (ResourceLocation)new ResourceLocation("simplemusket", "load_stage"), (stack, world, living, id) -> living == null || MusketItem.hasAmmo(stack) ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / (float)((Integer)Config.RELOAD_TIME.get()).intValue());
        ItemProperties.register((Item)MUSKET, (ResourceLocation)new ResourceLocation("simplemusket", "loaded"), (stack, world, living, id) -> living != null && MusketItem.isLoaded(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)MUSKET, (ResourceLocation)new ResourceLocation("simplemusket", "aiming"), (stack, world, living, id) -> living != null && living.m_21211_() == stack && living.m_6117_() && MusketItem.isLoaded(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)MUSKET, (ResourceLocation)new ResourceLocation("simplemusket", "sawnoff"), (stack, world, living, id) -> {
            MusketPillager pillager;
            return living instanceof MusketPillager && (pillager = (MusketPillager)living).isUsingSawnOff() ? 1.0f : 0.0f;
        });
    }

    public static void registerSensorGoal() {
        IdentityHashMap map = new IdentityHashMap((Map<EntityType<?>, Float>)VillagerHostilesSensorAccessor.getAcceptableDistance());
        map.put(GUNSLINGER, Float.valueOf(24.0f));
        VillagerHostilesSensorAccessor.setAcceptableDistance(ImmutableMap.copyOf(map));
    }

    public static class ArmorDecreaseEffect
    extends MobEffect {
        public ArmorDecreaseEffect(MobEffectCategory category, int color) {
            super(category, color);
        }
    }
}

