/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket;

import com.brokenkeyboard.simplemusket.Config;
import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.datagen.BastionLoot;
import com.brokenkeyboard.simplemusket.datagen.PiglinBarter;
import com.brokenkeyboard.simplemusket.entity.BulletEntity;
import com.brokenkeyboard.simplemusket.platform.Services;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="simplemusket")
public class SimpleMusket {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.f_256939_, (String)"simplemusket");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((ResourceKey)Registries.f_256764_, (String)"simplemusket");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> GLM = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"simplemusket");
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> BASTION_LOOT = GLM.register("bastion_loot", BastionLoot.CODEC);
    public static final RegistryObject<Codec<? extends IGlobalLootModifier>> PIGLIN_BARTER = GLM.register("piglin_barter", PiglinBarter.CODEC);

    public SimpleMusket() {
        FMLJavaModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        SimpleMusket.register(bus, Registries.f_256913_, ModRegistry::registerItems);
        SimpleMusket.register(bus, Registries.f_256939_, ModRegistry::registerEntity);
        SimpleMusket.register(bus, Registries.f_256762_, ModRegistry::registerEnchants);
        SimpleMusket.register(bus, Registries.f_256929_, ModRegistry::registerEffects);
        SimpleMusket.register(bus, Registries.f_256840_, ModRegistry::registerSounds);
        RECIPE_SERIALIZERS.register(bus);
        GLM.register(bus);
        bus.addListener(this::addCreative);
        bus.addListener(this::enqueueIMC);
    }

    public static <T> void register(IEventBus bus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<ResourceLocation, T>> source) {
        bus.addListener(event -> source.accept((location, t) -> event.register(registry, location, () -> t)));
    }

    public void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_256797_) {
            event.m_246326_((ItemLike)ModRegistry.MUSKET);
            event.m_246326_((ItemLike)ModRegistry.CARTRIDGE);
            event.m_246326_((ItemLike)ModRegistry.ENCHANTED_CARTRIDGE);
            event.m_246326_((ItemLike)ModRegistry.HELLFIRE_CARTRIDGE);
        }
        if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            event.m_246326_((ItemLike)ModRegistry.GUNSLINGER_EGG);
        }
    }

    public void enqueueIMC(InterModEnqueueEvent event) {
        if (Services.PLATFORM.isModLoaded("consecration")) {
            InterModComms.sendTo((String)"consecration", (String)"holy_attack", () -> (livingEntity, damageSource) -> {
                BulletEntity bullet;
                Entity patt4183$temp = damageSource.m_7640_();
                return patt4183$temp instanceof BulletEntity && (bullet = (BulletEntity)patt4183$temp).getBullet().equals(ModRegistry.ENCHANTED_CARTRIDGE);
            });
        }
        if (Services.PLATFORM.isModLoaded("usefulspyglass")) {
            InterModComms.sendTo((String)"usefulspyglass", (String)"precision", () -> ModRegistry.AIMING_MUSKET);
        }
    }
}

