/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.datagen;

import com.brokenkeyboard.simplemusket.datagen.DamageTags;
import com.brokenkeyboard.simplemusket.datagen.DataPackProvider;
import com.brokenkeyboard.simplemusket.datagen.EntityTags;
import com.brokenkeyboard.simplemusket.datagen.GLMProvider;
import com.brokenkeyboard.simplemusket.datagen.Recipes;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="simplemusket", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Datagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        if (event.includeServer()) {
            if (event.getInputs().contains(Path.of("commonData", new String[0]))) {
                DataPackProvider provider = new DataPackProvider(output, event.getLookupProvider());
                CompletableFuture lookupProvider = provider.getRegistryProvider();
                generator.addProvider(true, (DataProvider)provider);
                generator.addProvider(true, (DataProvider)new DamageTags(output, lookupProvider, event.getExistingFileHelper()));
                generator.addProvider(true, (DataProvider)new EntityTags(output, lookupProvider, event.getExistingFileHelper()));
            } else {
                generator.addProvider(true, (DataProvider)new Recipes(output));
                generator.addProvider(true, (DataProvider)new GLMProvider(output));
            }
        }
    }
}

