/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.entity;

import com.brokenkeyboard.simplemusket.Config;
import com.brokenkeyboard.simplemusket.Constants;
import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.item.BulletItem;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import com.brokenkeyboard.simplemusket.mixin.DamageSourcesInvoker;
import com.brokenkeyboard.simplemusket.platform.Services;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BulletEntity
extends Projectile {
    private int ticksAlive = 0;
    private BulletItem bullet = (BulletItem)ModRegistry.CARTRIDGE;
    private float damage = ((Double)Config.BULLET_DAMAGE.get()).floatValue();
    private float velocityPerc = 1.0f;
    @Nullable
    private ItemStack weapon;
    private boolean speedUpdated = false;

    public BulletEntity(EntityType<? extends BulletEntity> type, Level level) {
        super(type, level);
        this.m_20242_(true);
    }

    public BulletEntity(Level level, @Nullable Entity owner, Vec3 pos, ItemStack bullet, @Nullable ItemStack weapon) {
        this(ModRegistry.BULLET_ENTITY, level);
        this.m_5602_(owner);
        this.m_146884_(pos);
        if (MusketItem.BULLETS.test(bullet)) {
            this.bullet = (BulletItem)bullet.m_41720_();
        }
        if (((Object)((Object)this.bullet)).equals(ModRegistry.HELLFIRE_CARTRIDGE)) {
            this.damage *= 1.25f;
        }
        if (owner instanceof Mob) {
            this.damage = (float)((double)this.damage * (Double)Config.MOB_DAMAGE_MULT.get());
        }
        this.weapon = weapon != null && level instanceof ServerLevel ? weapon : null;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.ticksAlive > 300) {
            this.m_146870_();
        }
        ++this.ticksAlive;
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        Vec3 movement = this.m_20184_();
        float inertia = 1.0f;
        if (hitresult.m_6662_() != HitResult.Type.MISS && !Services.PLATFORM.bulletHitResult(this, hitresult)) {
            this.m_6532_(hitresult);
            this.f_19812_ = true;
        }
        if (this.m_20069_()) {
            inertia = 0.8f;
            this.velocityPerc *= 0.8f;
            for (int j = 0; j < 4; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_(), this.m_20186_(), this.m_20189_(), movement.f_82479_ * -0.2, movement.f_82480_ * -0.2, movement.f_82481_ * -0.2);
            }
        }
        if (this.velocityPerc < 0.2f) {
            this.m_146870_();
        } else if (this.velocityPerc < 0.5f) {
            this.m_20242_(false);
        }
        this.m_20256_(movement.m_82490_((double)inertia));
        this.m_146884_(this.m_20182_().m_82549_(movement));
        this.m_20101_();
    }

    protected void m_8097_() {
    }

    /*
     * Unable to fully structure code
     */
    protected void m_5790_(EntityHitResult hitResult) {
        entity = hitResult.m_82443_();
        target = Services.PLATFORM.getHitEntity(entity);
        owner = this.m_19749_();
        v0 = raiderFF = owner instanceof Raider != false && target instanceof Raider != false;
        if (!(owner instanceof Player)) ** GOTO lbl-1000
        player = (Player)owner;
        if (target instanceof Player && !player.m_7099_(player1 = (Player)target)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = playerFF = false;
        }
        if (raiderFF || playerFF) {
            return;
        }
        source = this.damageSource(this, owner);
        longshot = this.weapon != null ? EnchantmentHelper.m_44843_((Enchantment)ModRegistry.LONGSHOT, (ItemStack)this.weapon) : 0;
        distance = owner != null ? (double)Mth.m_14036_((float)owner.m_20270_(entity), (float)0.0f, (float)48.0f) : 0.0;
        this.damage = this.damage * this.velocityPerc * (target instanceof IronGolem != false ? 0.25f : 1.0f);
        if (this.m_9236_() instanceof ServerLevel && this.weapon != null && longshot > 0 && distance >= 16.0) {
            coef = Math.max((0.02929687616415322 * distance * distance - 0.4687500186264515 * distance + 15.000000953674316) * (double)(1.0f + 0.66f * (float)(longshot - 1)) / 100.0, 0.0);
            this.damage *= (float)(this.bullet.equals(ModRegistry.ENCHANTED_CARTRIDGE) != false ? 1.0 + coef * 1.2 : 1.0 + coef);
        }
        if (entity.m_6469_(source, this.damage) && entity instanceof LivingEntity) {
            living = (LivingEntity)entity;
            if (this.m_9236_() instanceof ServerLevel && owner instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)owner);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)living);
            }
            this.doPostHurtEffects(living);
        }
        this.m_146870_();
    }

    protected void doPostHurtEffects(LivingEntity entity) {
        if (((Object)((Object)this.bullet)).equals(ModRegistry.HELLFIRE_CARTRIDGE)) {
            entity.m_7292_(new MobEffectInstance(ModRegistry.ARMOR_DECREASE, 600));
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        this.m_146870_();
    }

    public DamageSource damageSource(BulletEntity bullet, @Nullable Entity attacker) {
        return ((DamageSourcesInvoker)this.m_9236_().m_269111_()).invokeSource(Constants.BULLET, (Entity)bullet, attacker);
    }

    public Item getBullet() {
        return this.bullet;
    }

    @Nullable
    public ItemStack getWeapon() {
        return this.weapon;
    }

    public static float applyArmorPiercing(float damage, float armor, float toughness, BulletEntity bullet) {
        float i = 2.0f + toughness / 4.0f;
        float reduction = Mth.m_14036_((float)(armor - damage / i), (float)(armor * 0.2f), (float)20.0f);
        float armorCoef = reduction / 25.0f;
        float firepower = bullet.weapon != null ? (float)EnchantmentHelper.m_44843_((Enchantment)ModRegistry.FIREPOWER, (ItemStack)bullet.weapon) * 0.1f : 0.0f;
        float piercingCoef = ((Object)((Object)bullet.bullet)).equals(ModRegistry.ENCHANTED_CARTRIDGE) ? 0.2f + firepower : 0.1f + firepower;
        return damage * (1.0f - Mth.m_14036_((float)(armorCoef - piercingCoef), (float)0.0f, (float)1.0f));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        Entity owner = this.m_19749_();
        return new ClientboundAddEntityPacket(this.m_19879_(), this.m_20148_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146909_(), this.m_146908_(), this.m_6095_(), owner != null ? owner.m_19879_() : 0, this.m_20184_().m_82490_((double)(3.9f / this.bullet.VELOCITY)), 0.0);
    }

    public void m_141965_(ClientboundAddEntityPacket packet) {
        super.m_141965_(packet);
        Vec3 velocity = new Vec3(packet.m_131503_(), packet.m_131504_(), packet.m_131505_());
        this.m_20256_(velocity.m_82490_(0.25641025641025644));
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (!this.m_20184_().equals((Object)Vec3.f_82478_) && this.m_9236_().f_46443_ && !this.speedUpdated) {
            this.m_20256_(this.m_20184_().m_82490_((double)this.bullet.VELOCITY));
            this.speedUpdated = true;
        }
    }
}

