/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.entity;

import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.entity.goal.MusketAttackGoal;
import com.brokenkeyboard.simplemusket.entity.goal.SawnOffGoal;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;

public class MusketPillager
extends AbstractIllager {
    private static final EntityDataAccessor<Boolean> SAWN_OFF = SynchedEntityData.m_135353_(MusketPillager.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int sawnoffCooldown = 0;

    public MusketPillager(EntityType<? extends MusketPillager> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SawnOffGoal(this, 8.0f));
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, (double)1.2f));
        this.f_21345_.m_25352_(3, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 8.0f));
        this.f_21345_.m_25352_(4, new MusketAttackGoal<MusketPillager>(this, 1.0f, 24.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(11, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.35);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SAWN_OFF, (Object)false);
    }

    public boolean m_5886_(ProjectileWeaponItem item) {
        return item.m_5456_() instanceof MusketItem;
    }

    public boolean isUsingSawnOff() {
        return (Boolean)this.f_19804_.m_135370_(SAWN_OFF);
    }

    public void setUsingSawnOff(boolean value) {
        this.f_19804_.m_135381_(SAWN_OFF, (Object)value);
    }

    public int getSawnoffCD() {
        return this.sawnoffCooldown;
    }

    public void setSawnoffCD(int value) {
        this.sawnoffCooldown = value;
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.sawnoffCooldown > 0) {
            --this.sawnoffCooldown;
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Sawnoff_cooldown", this.sawnoffCooldown);
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_21093_(stack -> stack.m_41720_() instanceof MusketItem)) {
            return this.m_6117_() ? AbstractIllager.IllagerArmPose.CROSSBOW_CHARGE : (this.isUsingSawnOff() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.CROSSBOW_HOLD);
        }
        return this.m_5912_() ? AbstractIllager.IllagerArmPose.ATTACKING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_21553_(true);
        this.sawnoffCooldown = tag.m_128451_("Sawnoff_cooldown");
    }

    public float m_5610_(BlockPos pos, LevelReader reader) {
        return 0.0f;
    }

    public int m_5792_() {
        return 1;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        RandomSource randomsource = accessor.m_213780_();
        this.m_213945_(randomsource, difficulty);
        this.m_213946_(randomsource, difficulty);
        return super.m_6518_(accessor, difficulty, type, groupData, tag);
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficulty) {
        ItemStack stack = new ItemStack((ItemLike)ModRegistry.MUSKET);
        MusketItem.setAmmo(stack, new ItemStack((ItemLike)ModRegistry.CARTRIDGE));
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    protected void m_214095_(RandomSource randomSource, float value) {
        ItemStack stack;
        super.m_214095_(randomSource, value);
        if (this.f_19796_.m_188503_(300) == 0 && (stack = this.m_21205_()).m_41720_() instanceof MusketItem) {
            Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
            map.putIfAbsent(ModRegistry.FIREPOWER, 1);
            EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack);
            this.m_8061_(EquipmentSlot.MAINHAND, stack);
        }
    }

    public boolean m_7307_(Entity $$0) {
        if (super.m_7307_($$0)) {
            return true;
        }
        if ($$0 instanceof LivingEntity && ((LivingEntity)$$0).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && $$0.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12307_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12309_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12310_;
    }

    public void m_7895_(int value, boolean bool) {
        Raid raid = this.m_37885_();
        if (raid == null || this.f_19796_.m_188501_() > raid.m_37783_()) {
            return;
        }
        ItemStack stack = new ItemStack((ItemLike)ModRegistry.MUSKET);
        HashMap map = Maps.newHashMap();
        if (value > raid.m_37724_(Difficulty.NORMAL)) {
            map.put(ModRegistry.LONGSHOT, 1);
        } else if (value > raid.m_37724_(Difficulty.EASY)) {
            map.put(ModRegistry.FIREPOWER, 1);
        }
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)stack);
        this.m_8061_(EquipmentSlot.MAINHAND, stack);
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12308_;
    }
}

