/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.entity.goal;

import com.brokenkeyboard.simplemusket.Config;
import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.item.BulletItem;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import java.util.EnumSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MusketAttackGoal<T extends Mob>
extends Goal {
    private static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T MOB;
    private final float SPEED_MODIFIER;
    private final float ATTACK_RANGE;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;

    public MusketAttackGoal(T mob, float speedModifier, float attackRange) {
        this.MOB = mob;
        this.SPEED_MODIFIER = speedModifier;
        this.ATTACK_RANGE = attackRange * attackRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected boolean isHoldingMusket() {
        return this.MOB.m_21093_(stack -> stack.m_41720_() instanceof MusketItem);
    }

    protected boolean isValidTarget() {
        return this.MOB.m_5448_() != null && this.MOB.m_5448_().m_6084_();
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingMusket();
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.MOB.m_21573_().m_26571_()) && this.isHoldingMusket();
    }

    public void m_8041_() {
        super.m_8041_();
        this.MOB.m_21561_(false);
        this.MOB.m_6710_(null);
        this.seeTime = 0;
        if (this.MOB.m_6117_()) {
            this.MOB.m_5810_();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        Item item;
        LivingEntity target = this.MOB.m_5448_();
        InteractionHand hand = ProjectileUtil.m_37297_(this.MOB, (Item)ModRegistry.MUSKET);
        ItemStack stack = this.MOB.m_21120_(hand);
        if (target != null && (item = this.MOB.m_21120_(hand).m_41720_()) instanceof MusketItem) {
            boolean moving;
            boolean seeTarget;
            MusketItem musket = (MusketItem)item;
            boolean hasLOS = this.MOB.m_21574_().m_148306_((Entity)target);
            boolean bl = seeTarget = this.seeTime > 0;
            if (hasLOS != seeTarget) {
                this.seeTime = 0;
            }
            this.seeTime = hasLOS ? this.seeTime + 1 : this.seeTime - 1;
            double distance = this.MOB.m_20280_((Entity)target);
            boolean bl2 = moving = (distance > (double)this.ATTACK_RANGE || this.seeTime < 5) && this.attackDelay == 0;
            if (moving) {
                if (--this.updatePathDelay <= 0) {
                    this.MOB.m_21573_().m_5624_((Entity)target, (double)this.SPEED_MODIFIER);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.MOB.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.MOB.m_21573_().m_26573_();
            }
            this.MOB.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (!MusketItem.isLoaded(stack) && !this.MOB.m_6117_()) {
                this.MOB.m_6672_(hand);
            } else if (!MusketItem.isLoaded(stack) && this.MOB.m_6117_() && this.MOB.m_21252_() > (Integer)Config.RELOAD_TIME.get()) {
                this.MOB.m_21253_();
                this.attackDelay = 50 + this.MOB.m_217043_().m_188503_(30);
            } else if (MusketItem.isLoaded(stack)) {
                if (this.attackDelay > 0) {
                    --this.attackDelay;
                } else if (hasLOS && this.seeTime > (Integer)Config.AIM_TIME.get()) {
                    this.MOB.m_9236_().m_9598_().m_6632_(Registries.f_256762_);
                    float velocity = ((BulletItem)MusketItem.getLoadedAmmo((ItemStack)stack).m_41720_()).VELOCITY;
                    float deviation = 8 - this.MOB.m_9236_().m_46791_().m_19028_() * 2;
                    musket.fire(this.MOB.m_9236_(), (LivingEntity)this.MOB, hand, stack, velocity, deviation, this.MOB.m_5448_(), SoundSource.HOSTILE);
                }
            }
        }
    }
}

