/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.entity.goal;

import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.entity.MusketPillager;
import com.brokenkeyboard.simplemusket.item.BulletItem;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import java.util.EnumSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SawnOffGoal
extends Goal {
    protected final MusketPillager MOB;
    protected final float ATTACK_RANGE;
    protected int attackDelay;

    public SawnOffGoal(MusketPillager mob, float attackRange) {
        this.MOB = mob;
        this.ATTACK_RANGE = attackRange * attackRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void m_8041_() {
        super.m_8041_();
        this.MOB.setUsingSawnOff(false);
    }

    public boolean m_8036_() {
        LivingEntity target = this.MOB.m_5448_();
        return target != null && target.m_6084_() && this.MOB.m_20280_((Entity)target) <= (double)this.ATTACK_RANGE && this.MOB.m_21093_(is -> is.m_41720_() instanceof MusketItem) && this.MOB.getSawnoffCD() <= 0;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.MOB.m_5448_();
        if (target != null && this.MOB.getSawnoffCD() <= 0) {
            Item item;
            InteractionHand hand = ProjectileUtil.m_37297_((LivingEntity)this.MOB, (Item)ModRegistry.MUSKET);
            ItemStack stack = this.MOB.m_21120_(hand);
            boolean hasLOS = this.MOB.m_21574_().m_148306_((Entity)target);
            this.MOB.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (!this.MOB.isUsingSawnOff()) {
                this.MOB.setUsingSawnOff(true);
                this.attackDelay = 20 + this.MOB.m_217043_().m_188503_(30);
            } else if (this.attackDelay > 0) {
                --this.attackDelay;
            } else if (hasLOS && (item = stack.m_41720_()) instanceof MusketItem) {
                MusketItem musket = (MusketItem)item;
                if (!MusketItem.isLoaded(stack)) {
                    MusketItem.setAmmo(stack, new ItemStack((ItemLike)ModRegistry.CARTRIDGE, 1));
                }
                float deviation = 8 - this.MOB.m_9236_().m_46791_().m_19028_() * 2;
                float velocity = ((BulletItem)MusketItem.getLoadedAmmo((ItemStack)stack).m_41720_()).VELOCITY;
                musket.fire(this.MOB.m_9236_(), (LivingEntity)this.MOB, hand, stack, velocity, deviation, this.MOB.m_5448_(), SoundSource.HOSTILE);
                this.MOB.setSawnoffCD(160);
                this.MOB.setUsingSawnOff(false);
                int amount = this.MOB.m_9236_() instanceof ServerLevel ? MusketItem.getAmmoCount(stack) : 1;
                MusketItem.setAmmo(stack, new ItemStack((ItemLike)ModRegistry.CARTRIDGE, amount));
            }
        }
    }
}

