/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.item;

import com.brokenkeyboard.simplemusket.ModRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnchCartridgeRecipe
extends CustomRecipe {
    public EnchCartridgeRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        if (container.m_280657_().size() < 3) {
            return false;
        }
        int book = 0;
        int gold = 0;
        int cartridge = 0;
        for (int i = 0; i < container.m_280657_().size(); ++i) {
            ItemStack stack = container.m_8020_(i);
            if (stack.m_150930_(Items.f_42690_)) {
                ++book;
                continue;
            }
            if (stack.m_150930_(Items.f_42587_)) {
                ++gold;
                continue;
            }
            if (!stack.m_150930_(ModRegistry.CARTRIDGE)) continue;
            ++cartridge;
        }
        return book == 1 && gold == cartridge;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer container) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)container.m_280657_().size(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = container.m_8020_(i);
            if (itemstack.m_41720_().m_41469_() != null) {
                nonnulllist.set(i, (Object)new ItemStack((ItemLike)itemstack.m_41720_().m_41469_()));
                continue;
            }
            if (!itemstack.m_150930_(Items.f_42690_)) continue;
            nonnulllist.set(i, (Object)new ItemStack((ItemLike)Items.f_42517_));
            break;
        }
        return nonnulllist;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess access) {
        return new ItemStack((ItemLike)ModRegistry.ENCHANTED_CARTRIDGE, (int)(container.m_280657_().stream().filter(stack -> !stack.m_150930_(ItemStack.f_41583_.m_41720_())).count() - 1L) / 2);
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRegistry.ENCH_CARTRIDGE_CRAFTING;
    }
}

