/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.item;

import com.brokenkeyboard.simplemusket.Config;
import com.brokenkeyboard.simplemusket.ModRegistry;
import com.brokenkeyboard.simplemusket.entity.BulletEntity;
import com.brokenkeyboard.simplemusket.item.BulletItem;
import com.brokenkeyboard.simplemusket.platform.Services;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MusketItem
extends ProjectileWeaponItem {
    public static final Predicate<ItemStack> BULLETS = stack -> stack.m_41720_() instanceof BulletItem;

    public MusketItem(Item.Properties properties) {
        super(properties.m_41499_(256));
    }

    public Predicate<ItemStack> m_6437_() {
        return BULLETS;
    }

    public int m_6615_() {
        return 40;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!(!MusketItem.isLoaded(stack) && player.m_6298_(stack).m_41619_() || player.m_204029_(FluidTags.f_13131_) || player.m_204029_(FluidTags.f_13132_))) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity.m_204029_(FluidTags.f_13131_) || entity.m_204029_(FluidTags.f_13132_)) {
            return;
        }
        if (MusketItem.isLoaded(stack)) {
            int aimTicks = this.m_8105_(stack) - timeLeft;
            float velocity = ((BulletItem)MusketItem.getLoadedAmmo((ItemStack)stack).m_41720_()).VELOCITY;
            float inaccuracy = 12 - Mth.m_14045_((int)(aimTicks / (Integer)Config.AIM_TIME.get()), (int)0, (int)1) * 12;
            this.fire(level, entity, entity.m_7655_(), stack, velocity, inaccuracy, null, SoundSource.PLAYERS);
        } else if (this.m_8105_(stack) - timeLeft >= (Integer)Config.RELOAD_TIME.get()) {
            int amount = MusketItem.getAmmoCount(stack);
            if (entity instanceof Mob) {
                MusketItem.setAmmo(stack, new ItemStack((ItemLike)ModRegistry.CARTRIDGE, amount));
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                ItemStack ammo = player.m_6298_(stack);
                if (player.m_150110_().f_35937_) {
                    MusketItem.setAmmo(stack, new ItemStack((ItemLike)(this.m_6437_().test(ammo) ? ammo.m_41720_() : ModRegistry.CARTRIDGE), amount));
                } else if (!ammo.m_41619_() && this.m_6437_().test(ammo)) {
                    MusketItem.setAmmo(stack, new ItemStack((ItemLike)ammo.m_41720_(), amount));
                    ammo.m_41774_(1);
                    if (ammo.m_41619_()) {
                        player.m_150109_().m_36057_(ammo);
                    }
                }
            }
        }
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int timeLeft) {
        SoundSource source;
        if (entity.m_204029_(FluidTags.f_13131_) || entity.m_204029_(FluidTags.f_13132_)) {
            entity.m_5810_();
        }
        int useTime = this.m_8105_(stack) - timeLeft;
        SoundSource soundSource = source = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
        if (!MusketItem.isLoaded(stack)) {
            if (Math.floor((double)((Integer)Config.RELOAD_TIME.get()).intValue() * 0.12) == (double)useTime) {
                level.m_6269_(null, (Entity)entity, ModRegistry.MUSKET_LOAD_0, source, 1.0f, 0.8f);
            } else if (Math.floor((double)((Integer)Config.RELOAD_TIME.get()).intValue() * 0.6) == (double)useTime) {
                level.m_6269_(null, (Entity)entity, ModRegistry.MUSKET_LOAD_1, source, 1.0f, 0.8f);
            } else if ((Integer)Config.RELOAD_TIME.get() == useTime) {
                level.m_6269_(null, (Entity)entity, ModRegistry.MUSKET_READY, source, 1.0f, 0.8f);
            }
        }
    }

    public void fire(Level level, LivingEntity shooter, InteractionHand hand, ItemStack stack, float velocity, float inaccuracy, @Nullable LivingEntity target, SoundSource source) {
        ServerLevel serverLevel;
        block6: {
            block5: {
                if (!(level instanceof ServerLevel)) break block5;
                serverLevel = (ServerLevel)level;
                if (!(shooter instanceof Mob) || target != null) break block6;
            }
            return;
        }
        ItemStack bulletStack = MusketItem.getLoadedAmmo(stack);
        Vec3 pos = new Vec3(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
        int ammoCount = bulletStack.m_41613_();
        BulletEntity bullet = new BulletEntity((Level)serverLevel, (Entity)shooter, pos, bulletStack, stack);
        bullet.m_146884_(pos);
        if (shooter instanceof Mob) {
            Mob mob = (Mob)shooter;
            Vec3 direction = MusketItem.mobTargetVec((LivingEntity)mob, target);
            bullet.m_6686_(direction.m_7096_(), direction.m_7098_(), direction.m_7094_(), velocity, inaccuracy);
        } else {
            bullet.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, velocity, inaccuracy);
        }
        level.m_7967_((Entity)bullet);
        MusketItem.setAmmo(stack, new ItemStack((ItemLike)bulletStack.m_41720_(), ammoCount - 1));
        Vec3 direction = shooter instanceof Mob ? MusketItem.mobTargetVec(shooter, target) : Vec3.m_82498_((float)shooter.m_146909_(), (float)shooter.m_146908_());
        Vec3 side = Vec3.m_82498_((float)0.0f, (float)(shooter.m_146908_() + (float)(hand == InteractionHand.MAIN_HAND ? 90 : -90)));
        Vec3 down = Vec3.m_82498_((float)(shooter.m_146909_() + 90.0f), (float)shooter.m_146908_());
        Vec3 smokePos = shooter.m_146892_().m_82549_(side.m_82549_(down).m_82490_(0.15));
        MusketItem.spawnParticles(level, smokePos, direction);
        Services.PLATFORM.playSound(ModRegistry.MUSKET_FIRE, source, serverLevel, shooter.m_20182_());
        stack.m_41622_(1, shooter, user -> user.m_21190_(user.m_7655_()));
    }

    public static void spawnParticles(Level level, Vec3 position, Vec3 direction) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = level.m_213780_();
        for (int i = 0; i < 10; ++i) {
            double t = Math.pow(random.m_188501_(), 1.5);
            Vec3 smokePos = position.m_82549_(direction.m_82490_(1.25 + t));
            smokePos = smokePos.m_82549_(new Vec3((double)random.m_188501_() - 0.5, (double)random.m_188501_() - 0.5, (double)random.m_188501_() - 0.5).m_82490_(0.1));
            Vec3 smokeVec = direction.m_82490_(0.1 * (1.0 - t));
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, smokePos.f_82479_, smokePos.f_82480_, smokePos.f_82481_, 0, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 1.0);
        }
    }

    public static Vec3 mobTargetVec(LivingEntity mob, LivingEntity target) {
        double vecY = target.m_20191_().f_82289_ + (double)(target.m_20206_() * 0.7f) - mob.m_20186_() - (double)mob.m_20192_();
        return new Vec3(target.m_20185_() - mob.m_20185_(), vecY, target.m_20189_() - mob.m_20189_()).m_82541_();
    }

    public static void setAmmo(ItemStack stack, ItemStack bullet) {
        if (bullet.m_41613_() < 1) {
            stack.m_41749_("LoadedProjectiles");
        } else {
            CompoundTag tag = new CompoundTag();
            stack.m_41700_("LoadedProjectiles", (Tag)bullet.m_41739_(tag));
        }
    }

    public static ItemStack getLoadedAmmo(ItemStack stack) {
        CompoundTag tag = stack.m_41737_("LoadedProjectiles");
        boolean valid = tag != null && stack.m_41720_() instanceof MusketItem;
        return valid && ((MusketItem)stack.m_41720_()).m_6437_().test(ItemStack.m_41712_((CompoundTag)tag)) ? ItemStack.m_41712_((CompoundTag)tag) : ItemStack.f_41583_;
    }

    public static int getAmmoCount(ItemStack stack) {
        int repeating = EnchantmentHelper.m_44843_((Enchantment)ModRegistry.REPEATING, (ItemStack)stack);
        if (repeating > 0) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                int amount = tag.m_128451_("AmmoBonus");
                stack.m_41749_("AmmoBonus");
                return repeating + amount + 1;
            }
            return repeating + 1;
        }
        return 1;
    }

    public static boolean hasAmmo(ItemStack stack) {
        return !MusketItem.getLoadedAmmo(stack).m_150930_(ItemStack.f_41583_.m_41720_());
    }

    public static boolean isLoaded(ItemStack stack) {
        return BULLETS.test(MusketItem.getLoadedAmmo(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        if (MusketItem.hasAmmo(stack)) {
            components.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_7220_(CommonComponents.f_263701_).m_7220_(MusketItem.getLoadedAmmo(stack).m_41611_()));
        }
    }

    public UseAnim m_6164_(ItemStack stack) {
        return MusketItem.hasAmmo(stack) ? UseAnim.BOW : UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }
}

