/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.network;

import com.brokenkeyboard.simplemusket.network.ClientPacketHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3f;

public class S2CSoundPacket {
    private final SoundEvent SOUND;
    private final SoundSource SOURCE;
    private final Vector3f POS;

    public S2CSoundPacket(SoundEvent sound, SoundSource source, Vector3f pos) {
        this.SOUND = sound;
        this.SOURCE = source;
        this.POS = pos;
    }

    public S2CSoundPacket(FriendlyByteBuf buf) {
        this.SOUND = SoundEvent.m_263214_((FriendlyByteBuf)buf);
        this.SOURCE = (SoundSource)buf.m_130066_(SoundSource.class);
        this.POS = buf.m_269394_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.SOUND.m_263231_(buf);
        buf.m_130068_((Enum)this.SOURCE);
        buf.m_269582_(this.POS);
    }

    public static void handleS2CSound(S2CSoundPacket packet, Supplier<NetworkEvent.Context> supplier) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientPacketHandler.playSound(packet.SOUND, packet.SOURCE, packet.POS);
        }
        supplier.get().setPacketHandled(true);
    }
}

