/*
 * Decompiled with CFR 0.152.
 */
package com.brokenkeyboard.simplemusket.platform;

import com.brokenkeyboard.simplemusket.SimpleMusket;
import com.brokenkeyboard.simplemusket.entity.BulletEntity;
import com.brokenkeyboard.simplemusket.item.MusketItem;
import com.brokenkeyboard.simplemusket.network.Network;
import com.brokenkeyboard.simplemusket.platform.services.IPlatformHelper;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;

public class ForgePlatformHelper
implements IPlatformHelper {
    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public boolean bulletHitResult(BulletEntity bullet, HitResult result) {
        return ForgeEventFactory.onProjectileImpact((Projectile)bullet, (HitResult)result);
    }

    @Override
    public void playSound(SoundEvent sound, SoundSource source, ServerLevel level, Vec3 origin) {
        Network.S2CSound(sound, source, (ResourceKey<Level>)level.m_46472_(), origin);
    }

    @Override
    public Entity getHitEntity(Entity entity) {
        Entity entity2;
        if (entity instanceof PartEntity) {
            PartEntity part = (PartEntity)entity;
            entity2 = part.getParent();
        } else {
            entity2 = entity;
        }
        return entity2;
    }

    @Override
    public EnchantmentCategory musketCategory() {
        return EnchantmentCategory.create((String)"MUSKET", item -> item instanceof MusketItem);
    }

    @Override
    public EntityType<? extends BulletEntity> createBulletEntity() {
        return EntityType.Builder.m_20704_(BulletEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20702_(4).m_20717_(20).setShouldReceiveVelocityUpdates(false).m_20712_("bullet");
    }

    @Override
    public <T extends CraftingRecipe> RecipeSerializer<T> createRecipeSerializer(String name, RecipeSerializer<T> serializer) {
        SimpleMusket.RECIPE_SERIALIZERS.register(name, () -> serializer);
        return serializer;
    }
}

