/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BuiltinPermission {
    public static final Map<ResourceLocation, ClaimPermission.Builder> DATAGEN_DATA = new LinkedHashMap<ResourceLocation, ClaimPermission.Builder>();
    private static final HashMap<String, ResourceLocation> LEGACY_MIGRATION = new HashMap();
    public static int order = 0;
    public static ResourceLocation EDITCLAIM = BuiltinPermission.register("edit_claim", new ItemStack((ItemLike)Items.f_42434_), "Gives permission to edit (resize, delete...) the claim");
    public static ResourceLocation EDITPERMS = BuiltinPermission.register("edit_perms", new ItemStack((ItemLike)Items.f_42116_), "Gives permission to change the claims permissions");
    public static ResourceLocation EDITPOTIONS = BuiltinPermission.register("edit_potions", new ItemStack((ItemLike)Items.f_42589_), "Gives permission to edit the claims potion effect");
    public static ResourceLocation BREAK = BuiltinPermission.register("break", new ItemStack((ItemLike)Items.f_42390_), "Permission to break blocks in the claim");
    public static ResourceLocation PLACE = BuiltinPermission.register("place", new ItemStack((ItemLike)Items.f_42276_), "Permission to place blocks in the claim");
    public static ResourceLocation OPENCONTAINER = BuiltinPermission.register("open_container", new ItemStack((ItemLike)Items.f_42009_), "Permission to open containers", "(chest, furnace etc.)");
    public static ResourceLocation INTERACTBLOCK = BuiltinPermission.register("interact_block", new ItemStack((ItemLike)Items.f_42587_), "Generic permission for block interaction.", "Fallback to OPENCONTAINER", "Gets used for all blocks OPENCONTAINER doesn't check for");
    public static ResourceLocation INTERACTSIGN = BuiltinPermission.register("interact_sign", new ItemStack((ItemLike)Items.f_42440_), "Permission to edit signs (e.g. dyeing them)");
    public static ResourceLocation ANVIL = BuiltinPermission.register("anvil", new ItemStack((ItemLike)Items.f_42146_), "Permission to use anvils");
    public static ResourceLocation BED = BuiltinPermission.register("bed", new ItemStack((ItemLike)Items.f_42570_), "Permission to use beds");
    public static ResourceLocation BEACON = BuiltinPermission.register("beacon", new ItemStack((ItemLike)Items.f_42065_), "Permission to use beacons");
    public static ResourceLocation DOOR = BuiltinPermission.register("door", new ItemStack((ItemLike)Items.f_42342_), "Permission to use doors");
    public static ResourceLocation FENCEGATE = BuiltinPermission.register("fence_gate", new ItemStack((ItemLike)Items.f_42030_), "Permission to use fence gates");
    public static ResourceLocation TRAPDOOR = BuiltinPermission.register("trapdoor", new ItemStack((ItemLike)Items.f_42056_), "Permission to use trapdoors");
    public static ResourceLocation BUTTONLEVER = BuiltinPermission.register("button_lever", new ItemStack((ItemLike)Items.f_41966_), "Permission to trigger levers and buttons");
    public static ResourceLocation PRESSUREPLATE = BuiltinPermission.register("pressure_plate", new ItemStack((ItemLike)Items.f_41967_), "Permission to trigger pressure plates");
    public static ResourceLocation NOTEBLOCK = BuiltinPermission.register("noteblock", new ItemStack((ItemLike)Items.f_41859_), "Permission to change noteblocks");
    public static ResourceLocation REDSTONE = BuiltinPermission.register("redstone", new ItemStack((ItemLike)Items.f_42451_), "Permission to change redstone components");
    public static ResourceLocation JUKEBOX = BuiltinPermission.register("jukebox", new ItemStack((ItemLike)Items.f_41984_), "Permission to insert/take music discs");
    public static ResourceLocation ENDERCHEST = BuiltinPermission.register("enderchest", new ItemStack((ItemLike)Items.f_42108_), true, "Permission to use enderchests");
    public static ResourceLocation ENCHANTMENTTABLE = BuiltinPermission.register("enchantment", new ItemStack((ItemLike)Items.f_42100_), true, "Permission to use enchanting tables");
    public static ResourceLocation ITEMFRAMEROTATE = BuiltinPermission.register("itemframe_rotate", new ItemStack((ItemLike)Items.f_42617_), "Permission to rotate items in item frames");
    public static ResourceLocation LECTERNTAKE = BuiltinPermission.register("lectern_take", new ItemStack((ItemLike)Items.f_42774_), "Permission to change books in a lectern");
    public static ResourceLocation ENDCRYSTALPLACE = BuiltinPermission.register("endcrystal_place", new ItemStack((ItemLike)Items.f_42729_), "Permission to place end crystals");
    public static ResourceLocation TARGETBLOCK = BuiltinPermission.register("target_block", new ItemStack((ItemLike)Items.f_42793_), "Permission to trigger target blocks");
    public static ResourceLocation PROJECTILES = BuiltinPermission.register("projectiles", new ItemStack((ItemLike)Items.f_42412_), "Permission to let shot projectiles", "interact with blocks (e.g. arrow on button)");
    public static ResourceLocation TRAMPLE = BuiltinPermission.register("trample", new ItemStack((ItemLike)Items.f_41961_), "Permission to enable block trampling", "(farmland, turtle eggs)");
    public static ResourceLocation FROSTWALKER = BuiltinPermission.register("frost_walker", new ItemStack((ItemLike)Items.f_42463_), "Permission for frostwalker to activate");
    public static ResourceLocation PORTAL = BuiltinPermission.register("portal", new ItemStack((ItemLike)Items.f_41999_), true, "Permission to use nether portals");
    public static ResourceLocation RAID = BuiltinPermission.register("raid", Raid.m_37779_(), "Permission to trigger raids in claim.", "Wont prevent raids (just) outside");
    public static ResourceLocation BOAT = BuiltinPermission.register("boat", new ItemStack((ItemLike)Items.f_42453_), "Permission to use boats");
    public static ResourceLocation MINECART = BuiltinPermission.register("minecart", new ItemStack((ItemLike)Items.f_42449_), "Permission to sit in minecarts");
    public static ResourceLocation BUCKET = BuiltinPermission.register("bucket", new ItemStack((ItemLike)Items.f_42446_), "Permission to take liquids with buckets");
    public static ResourceLocation ENDERPEARL = BuiltinPermission.register("ender_pearl", new ItemStack((ItemLike)Items.f_42584_), "Permission to use enderpearls");
    public static ResourceLocation CHORUSFRUIT = BuiltinPermission.register("chorus_fruit", new ItemStack((ItemLike)Items.f_42730_), "Permission to eat chorus fruits");
    public static ResourceLocation ANIMALINTERACT = BuiltinPermission.register("animal_interact", new ItemStack((ItemLike)Items.f_42552_), "Permission to interact with animals", "(e.g. shearing sheeps)");
    public static ResourceLocation HURTANIMAL = BuiltinPermission.register("hurt_animal", new ItemStack((ItemLike)Items.f_42579_), "Permission to hurt animals");
    public static ResourceLocation HURTNAMED = BuiltinPermission.register("hurt_named", new ItemStack((ItemLike)Items.f_42656_), false, "Permission to hurt named mobs");
    public static ResourceLocation XP = BuiltinPermission.register("xp", new ItemStack((ItemLike)Items.f_42612_), "Permission to pick up xp orbs");
    public static ResourceLocation TRADING = BuiltinPermission.register("trading", new ItemStack((ItemLike)Items.f_42616_), "Permission to trade with villagers");
    public static ResourceLocation ARMORSTAND = BuiltinPermission.register("armorstand", new ItemStack((ItemLike)Items.f_42650_), "Permission to interact with armor stands");
    public static ResourceLocation BREAKNONLIVING = BuiltinPermission.register("break_non_living", new ItemStack((ItemLike)Items.f_42657_), "Permission to break things like minecarts or armor stands");
    public static ResourceLocation DROP = BuiltinPermission.register("drop", new ItemStack((ItemLike)Items.f_42399_), true, "Allow the drop of items");
    public static ResourceLocation PICKUP = BuiltinPermission.register("pickup", new ItemStack((ItemLike)Items.f_42460_), true, "Allow the pickup of items");
    public static ResourceLocation ALLOW_FLIGHT = BuiltinPermission.register("flight", new ItemStack((ItemLike)Items.f_41913_), true, "Allows all non creative flight", "Does not grant flight!");
    public static ResourceLocation MAY_FLIGHT = BuiltinPermission.register("may_flight", order -> new ClaimPermission.Builder(new ItemStack((ItemLike)Items.f_42402_), (int)order, List.of("Allows player to fly in this claim.", "Flight permission needs to be true!")).requireExplicitSet(true).globalVal(false));
    public static ResourceLocation CANSTAY = BuiltinPermission.register("can_stay", new ItemStack((ItemLike)Items.f_42516_), true, "Allow players to enter your claim");
    public static ResourceLocation TELEPORT = BuiltinPermission.register("teleport", new ItemStack((ItemLike)Items.f_42101_), false, "Allow player to teleport to your claim home position");
    public static ResourceLocation NOHUNGER = BuiltinPermission.register("no_hunger", new ItemStack((ItemLike)Items.f_42580_), false, "Disable hunger");
    public static ResourceLocation CLAIMMESSAGE = BuiltinPermission.register("claim_message", new ItemStack((ItemLike)Items.f_42438_), false, "Permission to edit the enter/leave message");
    public static ResourceLocation ARCHAEOLOGY = BuiltinPermission.register("archeology", new ItemStack((ItemLike)Items.f_271356_), false, false, "Allow players to brush blocks in this claim");
    public static ResourceLocation HURTPLAYER = BuiltinPermission.register("hurt_player", new ItemStack((ItemLike)Items.f_42388_), false, true, "Permission to hurt other players");
    public static ResourceLocation EXPLOSIONS = BuiltinPermission.register("explosions", new ItemStack((ItemLike)Items.f_41996_), false, true, "Toggle explosions in claim");
    public static ResourceLocation WITHER = BuiltinPermission.register("wither", new ItemStack((ItemLike)Items.f_42679_), false, true, "Toggle wither breaking blocks in claim");
    public static ResourceLocation ENDERMAN = BuiltinPermission.register("enderman", new ItemStack((ItemLike)Items.f_42545_), true, true, "Allow enderman picking and placing blocks");
    public static ResourceLocation SNOWGOLEM = BuiltinPermission.register("snow_golem", new ItemStack((ItemLike)Items.f_41981_), true, true, "Allow snowgolems snowlayer");
    public static ResourceLocation FIRESPREAD = BuiltinPermission.register("fire_spread", new ItemStack((ItemLike)Items.f_42593_), false, true, "Toggle firespread in claim");
    public static ResourceLocation WATERBORDER = BuiltinPermission.register("water_border", new ItemStack((ItemLike)Items.f_42447_), false, true, "Toggle water crossing claim borders");
    public static ResourceLocation PISTONBORDER = BuiltinPermission.register("piston_border", new ItemStack((ItemLike)Items.f_41869_), false, true, "Toggle piston pull/push across claim borders");
    public static ResourceLocation MOBSPAWN = BuiltinPermission.register("mob_spawn", order -> new ClaimPermission.Builder(new ItemStack((ItemLike)Items.f_42608_), (int)order, List.of("Prevent hostile mobspawn in claim")).global(true).globalVal(false));
    public static ResourceLocation ANIMALSPAWN = BuiltinPermission.register("animal_spawn", order -> new ClaimPermission.Builder(new ItemStack((ItemLike)Items.f_42630_), (int)order, List.of("Prevent other spawn in claim")).global(true).globalVal(false));
    public static ResourceLocation LIGHTNING = BuiltinPermission.register("lightning", new ItemStack((ItemLike)Items.f_42713_), false, true, "Allow lightning to affect claims", "e.g. set blocks on fire", "or affect animals (mobs are excluded)");
    public static ResourceLocation LOCKITEMS = BuiltinPermission.register("lock_items", new ItemStack((ItemLike)Items.f_42689_), true, true, "If items should be locked on death");
    public static ResourceLocation FAKEPLAYER = BuiltinPermission.register("fake_player", new ItemStack((ItemLike)Items.f_42684_), false, true, "Allow fakeplayers to interact in this claim", "Some mods fakeplayer has the users uuid", "For those mods this permission is not needed");
    public static ResourceLocation PLAYERMOBSPAWN = BuiltinPermission.register("player_mob_spawn", new ItemStack((ItemLike)Items.f_220215_), false, true, "Permission for affected players to spawn mobs with interactions", "E.g. wardens, or endermites with enderpearls");
    public static ResourceLocation SCULK = BuiltinPermission.register("sculk", new ItemStack((ItemLike)Items.f_151042_), false, true, "Permission for sculk sensors.", "Shriekers are handled under PLAYERMOBSPAWN");

    private static ResourceLocation register(String id, ItemStack item, String ... description) {
        return BuiltinPermission.register(id, item, false, description);
    }

    private static ResourceLocation register(String id, ItemStack item, boolean defaultVal, String ... description) {
        return BuiltinPermission.register(id, item, defaultVal, false, description);
    }

    private static ResourceLocation register(String key, ItemStack item, boolean defaultVal, boolean global, String ... description) {
        return BuiltinPermission.register(key, order -> new ClaimPermission.Builder(item, (int)order, List.of(description)).defaultVal(defaultVal).global(global));
    }

    private static ResourceLocation register(String key, Function<Integer, ClaimPermission.Builder> builder) {
        ResourceLocation id = new ResourceLocation("flan", key);
        if (CrossPlatformStuff.INSTANCE.isDataGen()) {
            DATAGEN_DATA.put(id, builder.apply(order++));
        }
        LEGACY_MIGRATION.put(key.replace("_", "").toUpperCase(Locale.ROOT), id);
        return id;
    }

    public static void registerMapping(String key, ResourceLocation newId) {
        if (LEGACY_MIGRATION.containsKey(key)) {
            throw new IllegalArgumentException("A mapping with key " + key + " is already registered!");
        }
        LEGACY_MIGRATION.put(key, newId);
    }

    public static ResourceLocation tryLegacy(String key) {
        return LEGACY_MIGRATION.getOrDefault(key, new ResourceLocation(key.toLowerCase(Locale.ROOT)));
    }
}

