/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.logging.log4j.Logger;

public class InteractionOverrideManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "claim_interactions_override";
    private static final Gson GSON = new GsonBuilder().create();
    public static final Codec<List<Pair<Either<TagKey<Block>, Block>, ResourceLocation>>> BLOCK_CODEC = InteractionOverrideManager.tagOrEntryCodec(BuiltInRegistries.f_256975_).listOf();
    public static final Codec<List<Pair<Either<TagKey<Item>, Item>, ResourceLocation>>> ITEM_CODEC = InteractionOverrideManager.tagOrEntryCodec(BuiltInRegistries.f_257033_).listOf();
    public static final Codec<List<Pair<Either<TagKey<EntityType<?>>, EntityType<?>>, ResourceLocation>>> ENTITY_CODEC = InteractionOverrideManager.tagOrEntryCodec(BuiltInRegistries.f_256780_).listOf();
    public static final InteractionType<Block> BLOCK_LEFT_CLICK = new InteractionType(new ResourceLocation("flan", "block_left_click"), () -> new InteractionHolder<Block>((Registry<Block>)BuiltInRegistries.f_256975_, BLOCK_CODEC));
    public static final InteractionType<Block> BLOCK_INTERACT = new InteractionType(new ResourceLocation("flan", "block_interact"), () -> new InteractionHolder<Block>((Registry<Block>)BuiltInRegistries.f_256975_, BLOCK_CODEC));
    public static final InteractionType<Item> ITEM_USE = new InteractionType(new ResourceLocation("flan", "item_use"), () -> new InteractionHolder<Item>((Registry<Item>)BuiltInRegistries.f_257033_, ITEM_CODEC));
    public static final InteractionType<EntityType<?>> ENTITY_ATTACK = new InteractionType(new ResourceLocation("flan", "entity_attack"), () -> new InteractionHolder((Registry<EntityType<?>>)BuiltInRegistries.f_256780_, ENTITY_CODEC));
    public static final InteractionType<EntityType<?>> ENTITY_INTERACT = new InteractionType(new ResourceLocation("flan", "entity_interact"), () -> new InteractionHolder((Registry<EntityType<?>>)BuiltInRegistries.f_256780_, ENTITY_CODEC));
    public static final InteractionOverrideManager INSTANCE = new InteractionOverrideManager();
    private final Map<InteractionType<?>, InteractionHolder<?>> overrides = new HashMap();

    private InteractionOverrideManager() {
        super(GSON, DIRECTORY);
    }

    public static <T> Codec<Pair<Either<TagKey<T>, T>, ResourceLocation>> tagOrEntryCodec(Registry<T> registry) {
        return InteractionOverrideManager.tagOrEntryCodec(registry.m_123023_(), registry.m_194605_());
    }

    public static <T, O> Codec<Pair<Either<TagKey<T>, O>, ResourceLocation>> tagOrEntryCodec(ResourceKey<? extends Registry<T>> key, Codec<O> codec) {
        Codec tagOrEntry = Codec.either((Codec)Codec.STRING.flatXmap(r -> {
            if (r.startsWith("#")) {
                return DataResult.success((Object)TagKey.m_203882_((ResourceKey)key, (ResourceLocation)new ResourceLocation(r.substring(1))));
            }
            return DataResult.error(() -> "Not a tag value" + r);
        }, l -> DataResult.success((Object)("#" + String.valueOf(l.f_203868_())))), codec);
        return RecordCodecBuilder.create(builder -> builder.group((App)tagOrEntry.fieldOf("entry").forGetter(Pair::getFirst), (App)ResourceLocation.f_135803_.fieldOf("permission").forGetter(Pair::getSecond)).apply((Applicative)builder, Pair::of));
    }

    public static <T> List<T> expandTag(Registry<T> registry, TagKey<T> tag) {
        ArrayList elements = new ArrayList();
        registry.m_203431_(tag).ifPresent(n -> n.forEach(h -> elements.add(h.m_203334_())));
        return elements;
    }

    public ResourceLocation getBlockLeftClick(Block block) {
        return this.getOverride(BLOCK_LEFT_CLICK, block);
    }

    public ResourceLocation getBlockInteract(Block block) {
        return this.getOverride(BLOCK_INTERACT, block);
    }

    public ResourceLocation getItemUse(Item item) {
        return this.getOverride(ITEM_USE, item);
    }

    public ResourceLocation getEntityAttack(EntityType<?> entity) {
        return this.getOverride(ENTITY_ATTACK, entity);
    }

    public ResourceLocation getEntityInteract(EntityType<?> entity) {
        return this.getOverride(ENTITY_INTERACT, entity);
    }

    public <T> ResourceLocation getOverride(InteractionType<T> type, T entry) {
        return this.getHolder(type).get(entry);
    }

    private <T> InteractionHolder<T> getHolder(InteractionType<T> type) {
        return this.overrides.computeIfAbsent(type, k -> type.gen.get());
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        InteractionHolder<Block> map;
        this.overrides.clear();
        for (Block block : BuiltInRegistries.f_256975_) {
            map = this.getHolder(BLOCK_INTERACT);
            ObjectToPermissionMap.BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(block, (ResourceLocation)sub.get()));
        }
        for (Item item : BuiltInRegistries.f_257033_) {
            map = this.getHolder(ITEM_USE);
            ObjectToPermissionMap.ITEM_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(item, (ResourceLocation)sub.get()));
        }
        data.forEach((res, el) -> {
            try {
                JsonObject obj = el.getAsJsonObject();
                InteractionType<?> type = InteractionType.LOOKUP.get(new ResourceLocation(obj.get("type").getAsString()));
                if (type == null) {
                    throw new JsonParseException("InteractionType of value " + obj.get("type").getAsString() + " does not exist");
                }
                JsonElement values = obj.get("values");
                this.appendTo(this.getHolder(type), values);
            }
            catch (Exception ex) {
                Flan.LOGGER.error("Couldnt parse claim permission json {} {}", res, (Object)ex);
                ex.fillInStackTrace();
            }
        });
    }

    private <T> void appendTo(InteractionHolder<T> map, JsonElement element) {
        List elements = (List)map.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element).getOrThrow(false, arg_0 -> ((Logger)Flan.LOGGER).error(arg_0));
        elements.forEach(pair -> ((Either)pair.getFirst()).ifLeft(tag -> map.unresolvedTags.put(tag, (ResourceLocation)pair.getSecond())).ifRight(val -> map.direct.put(val, (ResourceLocation)pair.getSecond())));
    }

    public record InteractionType<T>(ResourceLocation id, Supplier<InteractionHolder<T>> gen) {
        static Map<ResourceLocation, InteractionType<?>> LOOKUP = new HashMap();

        public InteractionType(ResourceLocation id, Supplier<InteractionHolder<T>> gen) {
            this.id = id;
            this.gen = gen;
            if (LOOKUP.put(id, this) != null) {
                throw new IllegalStateException("Type already registered");
            }
        }
    }

    public static class InteractionHolder<T> {
        private final Registry<T> registry;
        private final Codec<List<Pair<Either<TagKey<T>, T>, ResourceLocation>>> codec;
        private final Map<T, ResourceLocation> direct = new HashMap<T, ResourceLocation>();
        private final Map<TagKey<T>, ResourceLocation> unresolvedTags = new HashMap<TagKey<T>, ResourceLocation>();
        private final Map<T, ResourceLocation> defaults = new HashMap<T, ResourceLocation>();

        public InteractionHolder(Registry<T> registry, Codec<List<Pair<Either<TagKey<T>, T>, ResourceLocation>>> codec) {
            this.registry = registry;
            this.codec = codec;
        }

        public ResourceLocation get(T val) {
            if (!this.unresolvedTags.isEmpty() || !this.defaults.isEmpty()) {
                this.resolve();
            }
            return this.direct.get(val);
        }

        private void resolve() {
            this.unresolvedTags.entrySet().stream().sorted(Comparator.comparing(e -> ((TagKey)e.getKey()).f_203868_())).forEach(entry -> InteractionOverrideManager.expandTag(this.registry, (TagKey)entry.getKey()).forEach(item -> {
                if (!this.direct.containsKey(item)) {
                    this.direct.put(item, (ResourceLocation)entry.getValue());
                }
            }));
            this.unresolvedTags.clear();
            this.defaults.forEach((key, value) -> {
                if (!this.direct.containsKey(key)) {
                    this.direct.put((T)key, (ResourceLocation)value);
                }
            });
            this.defaults.clear();
        }
    }
}

