/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PermissionManager
extends SimpleJsonResourceReloadListener {
    public static final String DIRECTORY = "claim_permissions";
    private static final Gson GSON = new GsonBuilder().create();
    public static final PermissionManager INSTANCE = new PermissionManager();
    private Map<ResourceLocation, ClaimPermission> permissions = ImmutableMap.of();
    private List<ClaimPermission> sorted = List.of();
    private static final Map<String, String> LEGACY = Map.of("requiredMod", "required_mod", "guiItem", "gui_item", "defaultVal", "default_value");

    private PermissionManager() {
        super(GSON, DIRECTORY);
    }

    @Nullable
    public ClaimPermission get(ResourceLocation id) {
        return this.permissions.get(id);
    }

    public Collection<ResourceLocation> getIds() {
        return this.permissions.keySet();
    }

    public Collection<ClaimPermission> getAll() {
        return this.sorted;
    }

    public boolean isGlobalPermission(ResourceLocation id) {
        ClaimPermission perm = this.get(id);
        return perm != null && perm.global;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        data.forEach((res, el) -> {
            try {
                ClaimPermission.Builder props = (ClaimPermission.Builder)ClaimPermission.Builder.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)PermissionManager.parseLegacy(res, el)).getOrThrow(false, arg_0 -> ((Logger)Flan.LOGGER).error(arg_0));
                if (props.verify()) {
                    builder.put(res, (Object)props.build((ResourceLocation)res));
                }
            }
            catch (Exception ex) {
                Flan.LOGGER.error("Couldn't parse claim permission json {} {}", res, (Object)ex);
                ex.fillInStackTrace();
            }
        });
        this.permissions = builder.build();
        this.sorted = this.permissions.values().stream().sorted().toList();
    }

    private static JsonElement parseLegacy(ResourceLocation id, JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            ArrayList legacy = new ArrayList();
            obj.keySet().forEach(key -> {
                if (LEGACY.containsKey(key)) {
                    legacy.add(key);
                }
            });
            legacy.forEach(key -> {
                JsonElement e = obj.get(key);
                obj.remove(key);
                obj.add(LEGACY.get(key), e);
            });
            if (!legacy.isEmpty()) {
                Flan.LOGGER.warn("Legacy claim_permission {}. Following keys are outdated {}. Please update them! Refer to the documentations", (Object)id, legacy);
            }
            return obj;
        }
        return element;
    }
}

