/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.mojang.authlib.GameProfile;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ClaimUtils {
    public static boolean check(ServerPlayer player, BlockPos pos, Claim claim, ResourceLocation perm, Consumer<Optional<Boolean>> cons) {
        if (claim == null) {
            cons.accept(Optional.empty());
            return false;
        }
        boolean hasPerm = claim.canInteract(player, perm, pos);
        cons.accept(Optional.of(hasPerm));
        return hasPerm;
    }

    public static Claim checkReturn(ServerPlayer player, ResourceLocation perm, Consumer<Optional<Boolean>> cons) {
        Claim claim;
        BlockPos pos = player.m_20183_();
        return ClaimUtils.check(player, pos, claim = ClaimStorage.get(player.m_284548_()).getClaimAt(pos), perm, cons) ? claim : null;
    }

    public static void noClaimMessage(ServerPlayer player) {
        player.m_5661_((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED), false);
    }

    public static Consumer<Optional<Boolean>> genericNoPermMessage(ServerPlayer player) {
        return b -> {
            if (!b.isPresent()) {
                ClaimUtils.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.m_5661_((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            }
        };
    }

    public static MutableComponent translatedText(String key, Object ... compArgs) {
        ArrayList<ChatFormatting> formattings = new ArrayList<ChatFormatting>();
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object obj : compArgs) {
            if (obj instanceof ChatFormatting) {
                ChatFormatting formatting = (ChatFormatting)obj;
                formattings.add(formatting);
                continue;
            }
            args.add(obj);
        }
        return Component.m_237110_((String)key, (Object[])args.toArray()).m_6270_(Style.f_131099_.m_131152_((ChatFormatting[])formattings.toArray(ChatFormatting[]::new)));
    }

    public static Optional<String> fetchUsername(UUID uuid, MinecraftServer server) {
        return ClaimUtils.fetchUsername(uuid, server, false);
    }

    public static Optional<String> fetchUsername(UUID uuid, MinecraftServer server, boolean fetch) {
        String ownerName = server.m_129927_().m_11002_(uuid).map(GameProfile::getName).orElse(null);
        if (ownerName == null && fetch) {
            GameProfile prof = new GameProfile(uuid, null);
            server.m_129925_().fillProfileProperties(prof, true);
            ownerName = prof.getName();
        }
        return Optional.ofNullable(ownerName);
    }
}

