/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.linguabib.api.LanguageAPI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class CommandHelp {
    public static int helpMessage(CommandContext<CommandSourceStack> context, Collection<CommandNode<CommandSourceStack>> nodes) {
        int page = IntegerArgumentType.getInteger(context, (String)"page");
        return CommandHelp.helpMessage(context, page, nodes);
    }

    public static int helpMessage(CommandContext<CommandSourceStack> context, int pageC, Collection<CommandNode<CommandSourceStack>> nodes) {
        List<String> subCommands = CommandHelp.registeredCommands(context, nodes);
        subCommands.remove("?");
        int max = subCommands.size() / 8;
        int page = Math.min(pageC, max);
        List<String> header = CommandHelp.lang(context, "flan.commands.helpHeader");
        for (String headerTxt : header) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ClaimUtils.translatedText(headerTxt, page, ChatFormatting.GREEN), false);
        }
        for (int i = 8 * page; i < 8 * (page + 1); ++i) {
            if (i >= subCommands.size()) continue;
            String sub = subCommands.get(i);
            MutableComponent cmdText = ClaimUtils.translatedText("flan.commands.helpCmdEntry", subCommands.get(i), ChatFormatting.GRAY);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> cmdText.m_130948_(cmdText.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help cmd " + sub))), false);
        }
        MutableComponent pageText = null;
        if (page > 0) {
            MutableComponent pageTextBack = ClaimUtils.translatedText("flan.commands.help.previous", ChatFormatting.DARK_GREEN);
            pageTextBack.m_130948_(pageTextBack.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help " + (page - 1))));
            pageText = pageTextBack;
        }
        if (page < max) {
            MutableComponent pageTextNext = ClaimUtils.translatedText("flan.commands.help.next", ChatFormatting.DARK_GREEN);
            pageTextNext.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/flan help " + (page + 1))));
            pageText = pageText != null ? pageText.m_7220_((Component)Component.m_237113_((String)" | ").m_130940_(ChatFormatting.DARK_GRAY)).m_7220_((Component)pageTextNext) : pageTextNext;
        }
        if (pageText != null) {
            MutableComponent txt = pageText;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> txt, false);
        }
        return 1;
    }

    public static int helpCmd(CommandContext<CommandSourceStack> context) {
        String command = StringArgumentType.getString(context, (String)"command");
        return CommandHelp.helpCmd(context, command);
    }

    public static int helpCmd(CommandContext<CommandSourceStack> context, String command) {
        List<String> cmdHelp = CommandHelp.lang(context, "flan.command." + command);
        List<String> header = CommandHelp.lang(context, "flan.commands.syntaxHeader");
        for (int i = 0; i < cmdHelp.size(); ++i) {
            String cmp = cmdHelp.get(i);
            if (i == 0) {
                for (String headerTxt : header) {
                    ((CommandSourceStack)context.getSource()).m_288197_(() -> ClaimUtils.translatedText(headerTxt, ClaimUtils.translatedText(cmp, new Object[0]), ChatFormatting.GREEN), false);
                }
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ClaimUtils.translatedText(cmp, ChatFormatting.GOLD), false);
        }
        if (command.equals("help")) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ClaimUtils.translatedText("flan.wiki", ChatFormatting.GOLD), false);
            MutableComponent wiki = ClaimUtils.translatedText("https://github.com/Flemmli97/Flan/wiki", ChatFormatting.GREEN);
            wiki.m_6270_(wiki.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Flemmli97/Flan/wiki")));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> wiki, false);
        }
        return 1;
    }

    public static List<String> registeredCommands(CommandContext<CommandSourceStack> context, Collection<CommandNode<CommandSourceStack>> nodes) {
        return nodes.stream().filter(node -> node.canUse((Object)((CommandSourceStack)context.getSource()))).map(CommandNode::getName).collect(Collectors.toList());
    }

    private static List<String> lang(CommandContext<CommandSourceStack> context, String key) {
        Entity entity = ((CommandSourceStack)context.getSource()).m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return LanguageAPI.getFormattedKeys((ServerPlayer)player, (String)key);
        }
        return LanguageAPI.getFormattedKeys((String)LanguageAPI.defaultServerLanguage(), (String)key);
    }
}

