/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuySellHandler {
    public static final Codec<ItemStack> ITEM_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().fieldOf("id").forGetter(ItemStack::m_41720_), (App)CompoundTag.f_128325_.optionalFieldOf("tag").forGetter(itemStack -> Optional.ofNullable(itemStack.m_41783_()))).apply((Applicative)instance, (item, tag) -> {
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        tag.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
        return stack;
    }));
    private static int[] xpCalc;
    private Type buyType = Type.MONEY;
    private Type sellType = Type.MONEY;
    private float buyAmount = -1.0f;
    private final List<BuyItem> buyItems = new ArrayList<BuyItem>();
    private float sellAmount = -1.0f;
    private final List<SellItem> sellItems = new ArrayList<SellItem>();

    private static ItemStack fromResults(List<ItemResult> stacks) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42616_);
        stack.m_41714_((Component)Component.m_237115_((String)"flan.buy_sell.item").m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131157_(ChatFormatting.AQUA)));
        ArrayList<Component> stackComp = new ArrayList<Component>();
        for (ItemResult r : stacks) {
            stackComp.add((Component)Component.m_237110_((String)"flan.buy_sell.item.amount", (Object[])new Object[]{Component.m_237115_((String)r.stack().m_41778_()), r.amount(), Float.valueOf(r.value())}).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131157_(ChatFormatting.GREEN)));
        }
        ServerScreenHelper.addLore(stack, stackComp);
        return stack;
    }

    public boolean buy(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.buyAmount == -1.0f && this.buyType != Type.ITEM) {
            message.accept((Component)ClaimUtils.translatedText("flan.buyDisabled", ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (ConfigHandler.CONFIG.maxBuyBlocks >= 0 && data.getAdditionalClaims() + blocks > ConfigHandler.CONFIG.maxBuyBlocks) {
            message.accept((Component)ClaimUtils.translatedText("flan.buyLimit", ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.buyType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.buyClaimBlocks(player, blocks, this.buyAmount, message);
            }
            case 1: {
                if (this.buyItems.isEmpty()) {
                    message.accept((Component)ClaimUtils.translatedText("flan.buyDisabled", ChatFormatting.DARK_RED));
                    return false;
                }
                int payed = 0;
                ArrayList<ItemResult> bought = new ArrayList<ItemResult>();
                ArrayList<Pair> matching = new ArrayList<Pair>();
                block5: for (BuyItem ing : this.buyItems) {
                    for (ItemStack stack : player.m_150109_().f_35974_) {
                        if (!this.matches(ing.predicate(), stack) || stack.m_41763_() && stack.m_41773_() != 0) continue;
                        float toPay = blocks - payed;
                        int count = Math.min(stack.m_41613_(), (int)(toPay / ing.amount()));
                        float amount = (float)count * ing.amount();
                        payed = (int)((float)payed + amount);
                        if (count > 0) {
                            bought.add(new ItemResult(stack.m_41777_(), count, ing.amount()));
                            matching.add(Pair.of((Object)stack, (Object)count));
                        }
                        if (payed < blocks) continue;
                        break block5;
                    }
                }
                if (payed == 0 || matching.isEmpty()) {
                    message.accept((Component)ClaimUtils.translatedText("flan.buyFailItem", ChatFormatting.DARK_RED));
                    return false;
                }
                for (Pair stack : matching) {
                    ((ItemStack)stack.getFirst()).m_41774_(((Integer)stack.getSecond()).intValue());
                }
                MutableComponent items = Component.m_237115_((String)"flan.buy_sell.items").m_130948_(Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(BuySellHandler.fromResults(bought)))));
                data.setAdditionalClaims(data.getAdditionalClaims() + payed);
                message.accept((Component)ClaimUtils.translatedText("flan.buySuccessItem", payed, items));
                return true;
            }
            case 2: {
                int deduct = Mth.m_14167_((float)((float)blocks * this.buyAmount));
                if ((float)deduct < (float)BuySellHandler.totalXpPointsForLevel(player.f_36078_) + player.f_36080_ * (float)BuySellHandler.xpForLevel(player.f_36078_ + 1)) {
                    player.m_6756_(-deduct);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((Component)ClaimUtils.translatedText("flan.buySuccessXP", blocks, deduct));
                    return true;
                }
                message.accept((Component)ClaimUtils.translatedText("flan.buyFailXP", ChatFormatting.DARK_RED));
                return false;
            }
        }
        return false;
    }

    public boolean sell(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.sellAmount == -1.0f && this.sellType != Type.ITEM) {
            message.accept((Component)ClaimUtils.translatedText("flan.sellDisabled", ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
            message.accept((Component)ClaimUtils.translatedText("flan.sellFail", ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.sellType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.sellClaimBlocks(player, blocks, this.sellAmount, message);
            }
            case 1: {
                if (this.sellItems.isEmpty()) {
                    message.accept((Component)ClaimUtils.translatedText("flan.sellDisabled", ChatFormatting.DARK_RED));
                    return false;
                }
                int toSell = blocks;
                ArrayList<ItemResult> soldStacks = new ArrayList<ItemResult>();
                for (SellItem item : this.sellItems) {
                    int count = (int)((float)toSell / item.amount());
                    float amount = (float)count * item.amount();
                    toSell = (int)((float)toSell - amount);
                    while (count > 0) {
                        ItemEntity itemEntity;
                        ItemStack toGive = item.item().m_41777_();
                        if (count > 64) {
                            toGive.m_41764_(64);
                            count -= 64;
                        } else {
                            toGive.m_41764_(count);
                            count = 0;
                        }
                        soldStacks.add(new ItemResult(toGive.m_41777_(), toGive.m_41613_(), item.amount()));
                        boolean bl = player.m_150109_().m_36054_(toGive);
                        if (bl && toGive.m_41619_() || (itemEntity = player.m_36176_(toGive, false)) == null) continue;
                        itemEntity.m_32061_();
                        itemEntity.m_266426_(player.m_20148_());
                    }
                    if (toSell > 0) continue;
                    break;
                }
                int sold = blocks - toSell;
                MutableComponent items = Component.m_237115_((String)"flan.buy_sell.items").m_130948_(Style.f_131099_.m_131157_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130832_, (Object)new HoverEvent.ItemStackInfo(BuySellHandler.fromResults(soldStacks)))));
                data.setAdditionalClaims(data.getAdditionalClaims() - sold);
                message.accept((Component)ClaimUtils.translatedText("flan.sellSuccessItem", sold, items));
                return true;
            }
            case 2: {
                int amount = Mth.m_14143_((float)((float)blocks * this.buyAmount));
                player.m_6756_(amount);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)ClaimUtils.translatedText("flan.sellSuccessXP", blocks, amount));
                return false;
            }
        }
        return false;
    }

    private boolean matches(ItemPredicate predicate, ItemStack stack) {
        ItemStack def = new ItemStack((ItemLike)stack.m_41720_());
        boolean onlyRenamed = true;
        if (predicate.m_45049_(def) && stack.m_41782_()) {
            CompoundTag tag;
            onlyRenamed = stack.m_41783_().m_128431_().stream().allMatch(s -> s.equals("Damage") || s.equals("RepairCost") || s.equals("display")) ? (tag = stack.m_41783_().m_128469_("display")).m_128441_("Name") && tag.m_128440_() == 1 : false;
        }
        return onlyRenamed && predicate.m_45049_(stack);
    }

    private static int totalXpPointsForLevel(int level) {
        if (xpCalc == null || level > xpCalc.length) {
            xpCalc = new int[level + 50];
            BuySellHandler.xpCalc[0] = 0;
            for (int i = 1; i < xpCalc.length; ++i) {
                BuySellHandler.xpCalc[i] = BuySellHandler.xpForLevel(i) + xpCalc[i - 1];
            }
        }
        return xpCalc[level];
    }

    private static int xpForLevel(int level) {
        if (--level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("buyType", this.buyType.toString());
        obj.addProperty("buyValue", (Number)Float.valueOf(this.buyAmount));
        JsonArray buyArr = new JsonArray();
        this.buyItems.forEach(b -> {
            JsonObject buyObj = new JsonObject();
            buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
            buyObj.add("predicate", b.predicate().m_45048_());
            buyArr.add((JsonElement)buyObj);
        });
        obj.add("buyItems", (JsonElement)buyArr);
        obj.addProperty("sellType", this.sellType.toString());
        obj.addProperty("sellValue", (Number)Float.valueOf(this.sellAmount));
        JsonArray sellArr = new JsonArray();
        this.sellItems.forEach(b -> {
            JsonObject buyObj = new JsonObject();
            buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
            buyObj.add("item", (JsonElement)ITEM_STACK_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)b.item).getOrThrow(false, arg_0 -> ((Logger)Flan.LOGGER).error(arg_0)));
            sellArr.add((JsonElement)buyObj);
        });
        obj.add("sellItems", (JsonElement)sellArr);
        return obj;
    }

    public void fromJson(JsonObject object) {
        this.buyType = Type.valueOf(ConfigHandler.fromJson(object, "buyType", this.buyType.toString()));
        this.buyAmount = object.has("buyValue") ? object.get("buyValue").getAsFloat() : this.buyAmount;
        this.buyItems.clear();
        JsonArray buyArr = ConfigHandler.arryFromJson(object, "buyItems");
        buyArr.forEach(k -> {
            JsonObject o = k.getAsJsonObject();
            this.buyItems.add(new BuyItem(o.get("amount").getAsFloat(), ItemPredicate.m_45051_((JsonElement)o.get("predicate"))));
        });
        this.buyItems.sort(BuyItem::compareTo);
        this.sellType = Type.valueOf(ConfigHandler.fromJson(object, "sellType", this.sellType.toString()));
        this.sellAmount = object.has("sellValue") ? object.get("sellValue").getAsFloat() : this.sellAmount;
        this.sellItems.clear();
        JsonArray sellArr = ConfigHandler.arryFromJson(object, "sellItems");
        sellArr.forEach(k -> {
            JsonObject o = k.getAsJsonObject();
            this.sellItems.add(new SellItem(o.get("amount").getAsFloat(), (ItemStack)ITEM_STACK_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)o.get("item")).getOrThrow(false, arg_0 -> ((Logger)Flan.LOGGER).error(arg_0))));
        });
        this.sellItems.sort(SellItem::compareTo);
    }

    static enum Type {
        MONEY,
        ITEM,
        XP;

    }

    record ItemResult(ItemStack stack, int amount, float value) {
    }

    record BuyItem(float amount, ItemPredicate predicate) implements Comparable<BuyItem>
    {
        @Override
        public int compareTo(@NotNull BuyItem buyItem) {
            return Float.compare(buyItem.amount, this.amount);
        }
    }

    record SellItem(float amount, ItemStack item) implements Comparable<SellItem>
    {
        @Override
        public int compareTo(@NotNull SellItem item) {
            return Float.compare(item.amount, this.amount);
        }
    }
}

