/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.config.BuySellHandler;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ConfigUpdater {
    private static final Map<Integer, Updater> UPDATER = Config.createHashMap(map -> {
        map.put(6, new Updater(){

            @Override
            public JsonObject configUpdater(JsonObject oldVals) {
                return oldVals;
            }

            @Override
            public void postUpdater(Config config) {
                config.globalDefaultPerms.computeIfPresent("*", (k, v) -> {
                    v.put(BuiltinPermission.ALLOW_FLIGHT, Config.GlobalType.ALLTRUE);
                    v.put(BuiltinPermission.MAY_FLIGHT, Config.GlobalType.ALLFALSE);
                    return v;
                });
            }
        });
        map.put(5, config -> {
            Flan.debug("Updating config to version 5", new Object[0]);
            JsonObject buySellHandler = ConfigHandler.fromJson(config, "buySellHandler");
            JsonArray buyItems = ConfigHandler.arryFromJson(buySellHandler, "buyIngredients");
            ArrayList toRemove = new ArrayList();
            buyItems.forEach(k -> {
                JsonObject o = k.getAsJsonObject();
                if (o.has("ingredient")) {
                    try {
                        Ingredient ingredient = Ingredient.m_43917_((JsonElement)o.get("ingredient"));
                        ItemPredicate pred = ItemPredicate.Builder.m_45068_().m_151445_((ItemLike[])Arrays.stream(ingredient.m_43908_()).map(ItemStack::m_41720_).toArray(ItemLike[]::new)).m_45077_();
                        o.add("predicate", pred.m_45048_());
                        o.remove("ingredient");
                    }
                    catch (JsonParseException jsonParseException) {
                        // empty catch block
                    }
                }
                if (!o.has("predicate") || !o.has("amount")) {
                    Flan.error("Unable to update buy handler ", o);
                    toRemove.add(k);
                }
            });
            toRemove.forEach(arg_0 -> ((JsonArray)buyItems).remove(arg_0));
            buySellHandler.add("buyItems", (JsonElement)buyItems);
            if (buySellHandler.has("ingredient") || buySellHandler.has("sellIngredient")) {
                Ingredient legacy = buySellHandler.has("ingredient") ? Ingredient.m_43917_((JsonElement)buySellHandler.get("ingredient")) : Ingredient.f_43901_;
                Ingredient ingredient = legacy = buySellHandler.has("sellIngredient") ? Ingredient.m_43917_((JsonElement)buySellHandler.get("sellIngredient")) : legacy;
                if (!legacy.m_43947_() && !legacy.m_43908_()[0].m_41619_()) {
                    buySellHandler.add("sellItems", (JsonElement)BuySellHandler.ITEM_STACK_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)legacy.m_43908_()[0]).result().map(e -> {
                        JsonArray arr = new JsonArray();
                        JsonObject val = new JsonObject();
                        val.add("amount", buySellHandler.get("sellValue"));
                        val.add("item", e);
                        arr.add((JsonElement)val);
                        return arr;
                    }).orElse(new JsonArray()));
                } else {
                    buySellHandler.add("sellItems", (JsonElement)new JsonArray());
                }
            }
            return config;
        });
    });

    public static JsonObject updateConfig(int preVersion, JsonObject config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            config = updater.getValue().configUpdater(config);
        }
        return config;
    }

    public static void postUpdateConfig(int preVersion, Config config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            updater.getValue().postUpdater(config);
        }
    }

    static interface Updater {
        public JsonObject configUpdater(JsonObject var1);

        default public void postUpdater(Config config) {
        }
    }
}

