/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.mixin.IHungerAccessor;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.LogoutTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.utils.IOwnedItem;
import io.github.flemmli97.flan.utils.TeleportUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.phys.Vec3;

public class PlayerEvents {
    public static void saveClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).save(player.m_20194_());
        }
    }

    public static void readClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).read(player.m_20194_());
        }
    }

    public static void onLogout(Player player) {
        if (player.m_20194_() != null) {
            LogoutTracker.getInstance(player.m_20194_()).track(player.m_20148_());
        }
    }

    public static boolean growBonemeal(UseOnContext context) {
        Player player = context.m_43723_();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockState state = serverPlayer.m_9236_().m_8055_(context.m_8083_());
            BlockPos.MutableBlockPos pos = context.m_8083_().m_122032_();
            ResourceLocation perm = InteractionOverrideManager.INSTANCE.getItemUse(context.m_43722_().m_41720_());
            if (perm != null && !ClaimStorage.get(serverPlayer.m_284548_()).getForPermissionCheck((BlockPos)pos).canInteract(serverPlayer, perm, (BlockPos)pos, false)) {
                return false;
            }
            int range = 0;
            Registry registry = serverPlayer.m_9236_().m_9598_().m_175515_(Registries.f_256911_);
            if (state.m_60734_() instanceof MossBlock) {
                VegetationPatchConfiguration cfg = PlayerEvents.featureRange(registry, CaveFeatures.f_194951_, VegetationPatchConfiguration.class);
                if (cfg != null) {
                    range = cfg.f_161289_.m_142737_() + 1;
                    pos.m_122178_(pos.m_123341_(), pos.m_123342_() + cfg.f_161287_ + 1, pos.m_123343_());
                }
            } else if (state.m_60734_() instanceof GrassBlock) {
                range = 4;
            } else if (state.m_60713_(Blocks.f_50699_)) {
                NetherForestVegetationConfig cfg = PlayerEvents.featureRange(registry, NetherFeatures.f_195037_, NetherForestVegetationConfig.class);
                if (cfg != null) {
                    range = cfg.f_191259_;
                    pos.m_122178_(pos.m_123341_(), pos.m_123342_() + cfg.f_191260_ + 1, pos.m_123343_());
                }
            } else if (state.m_60713_(Blocks.f_50690_)) {
                NetherForestVegetationConfig cfg = PlayerEvents.featureRange(registry, NetherFeatures.f_195040_, NetherForestVegetationConfig.class);
                NetherForestVegetationConfig cfg2 = PlayerEvents.featureRange(registry, NetherFeatures.f_195042_, NetherForestVegetationConfig.class);
                TwistingVinesConfig cfg3 = PlayerEvents.featureRange(registry, NetherFeatures.f_195044_, TwistingVinesConfig.class);
                int w1 = cfg == null ? 0 : cfg.f_191259_;
                int w2 = cfg2 == null ? 0 : cfg2.f_191259_;
                int w3 = cfg3 == null ? 0 : cfg3.f_191365_();
                int h1 = cfg == null ? 0 : cfg.f_191260_;
                int h2 = cfg2 == null ? 0 : cfg2.f_191260_;
                int h3 = cfg3 == null ? 0 : cfg3.f_191366_();
                range = Math.max(Math.max(w1, w2), w3);
                int y = Math.max(Math.max(h1, h2), h3);
                pos.m_122178_(pos.m_123341_(), pos.m_123342_() + y + 1, pos.m_123343_());
            }
            if (range > 0 && perm != null && !ClaimStorage.get(serverPlayer.m_284548_()).canInteract((BlockPos)pos, range, serverPlayer, perm, false)) {
                serverPlayer.m_5661_((Component)ClaimUtils.translatedText("flan.tooCloseClaim", ChatFormatting.DARK_RED), true);
                return true;
            }
        }
        return false;
    }

    public static float canSpawnFromPlayer(Entity entity, float old) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockPos pos = player.m_20183_();
            if (!ClaimStorage.get(player.m_284548_()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.PLAYERMOBSPAWN, pos, false)) {
                return -1.0f;
            }
        }
        return old;
    }

    public static boolean canWardenSpawnTrigger(BlockPos pos, ServerPlayer player) {
        return ClaimStorage.get(player.m_284548_()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.PLAYERMOBSPAWN, pos, false);
    }

    public static boolean canSculkTrigger(BlockPos pos, ServerPlayer player) {
        return ClaimStorage.get(player.m_284548_()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.SCULK, pos, false);
    }

    public static <T extends FeatureConfiguration> T featureRange(Registry<ConfiguredFeature<?, ?>> registry, ResourceKey<ConfiguredFeature<?, ?>> key, Class<T> clss) {
        return (T)((FeatureConfiguration)registry.m_203636_(key).map(r -> {
            if (clss.isInstance(((ConfiguredFeature)r.m_203334_()).f_65378_())) {
                return ((ConfiguredFeature)r.m_203334_()).f_65378_();
            }
            return null;
        }).orElse(null));
    }

    public static boolean xpAbsorb(Player player) {
        BlockPos pos;
        ClaimStorage storage;
        IPermissionContainer claim;
        if (player instanceof ServerPlayer && (claim = (storage = ClaimStorage.get((ServerLevel)player.m_9236_())).getForPermissionCheck(pos = player.m_20183_())) != null) {
            return !claim.canInteract((ServerPlayer)player, BuiltinPermission.XP, pos, false);
        }
        return false;
    }

    public static boolean canCollideWith(Player player, Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            if (entity instanceof ItemEntity) {
                BlockPos pos;
                IOwnedItem ownedItem = (IOwnedItem)entity;
                if (ownedItem.getDeathPlayer() != null) {
                    ServerPlayer other = sPlayer.m_20194_().m_6846_().m_11259_(ownedItem.getDeathPlayer());
                    if (other == null) {
                        return false;
                    }
                    return ownedItem.getDeathPlayer().equals(player.m_20148_()) || PlayerClaimData.get(other).deathItemsUnlocked();
                }
                if (sPlayer.m_20148_().equals(ownedItem.getPlayerOrigin())) {
                    return true;
                }
                ClaimStorage storage = ClaimStorage.get(sPlayer.m_284548_());
                IPermissionContainer claim = storage.getForPermissionCheck(pos = sPlayer.m_20183_());
                if (claim != null) {
                    return claim.canInteract(sPlayer, BuiltinPermission.PICKUP, pos, false);
                }
            }
        }
        return true;
    }

    public static boolean canDropItem(Player player, ItemStack stack) {
        if (!player.m_21224_() && player instanceof ServerPlayer) {
            ClaimStorage storage = ClaimStorage.get((ServerLevel)player.m_9236_());
            BlockPos pos = player.m_20183_();
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            boolean allow = true;
            if (claim != null) {
                allow = claim.canInteract((ServerPlayer)player, BuiltinPermission.DROP, pos, false);
            }
            if (!allow) {
                player.m_150109_().m_36054_(stack);
                NonNullList stacks = NonNullList.m_122779_();
                for (int j = 0; j < player.f_36096_.f_38839_.size(); ++j) {
                    ItemStack itemStack2 = ((Slot)player.f_36096_.f_38839_.get(j)).m_7993_();
                    stacks.add((Object)(itemStack2.m_41619_() ? ItemStack.f_41583_ : itemStack2));
                }
                ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundContainerSetContentPacket(player.f_36096_.f_38840_, 0, stacks, player.f_36095_.m_142621_()));
            }
            return allow;
        }
        return true;
    }

    public static void updateDroppedItem(Player player, ItemEntity entity) {
        ((IOwnedItem)entity).setOriginPlayer(player);
    }

    public static Claim currentClaimTick(ServerPlayer player, Claim currentClaim) {
        Claim permissionContainer;
        Vec3 pos = player.m_20182_();
        BlockPos rounded = TeleportUtils.roundedBlockPos(pos.m_82520_(0.0, (double)player.m_6431_(player.m_20089_(), player.m_6972_(player.m_20089_())), 0.0));
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        Claim newClaim = currentClaim;
        if (currentClaim != null) {
            if (!currentClaim.intersects(player.m_20191_())) {
                Claim claim2;
                boolean isSub = currentClaim.parentClaim() != null;
                Claim claim3 = claim2 = isSub ? storage.getClaimAt(rounded) : currentClaim.parentClaim();
                if (claim2 == null) {
                    currentClaim.displayLeaveTitle(player);
                    if (!PlayerEvents.gameModeCanFly(player.f_8941_.m_9290_())) {
                        CrossPlatformStuff.INSTANCE.toggleCreativeFlight(player, false);
                    }
                } else {
                    Claim sub = claim2.getSubClaim(rounded);
                    boolean display = true;
                    if (sub != null) {
                        claim2 = sub;
                    } else {
                        boolean bl = display = currentClaim.enterTitle != null;
                        if (claim2.enterTitle == null) {
                            currentClaim.displayLeaveTitle(player);
                        }
                    }
                    if (display) {
                        claim2.displayEnterTitle(player);
                    }
                }
                newClaim = claim2;
            } else {
                Claim sub;
                if (currentClaim.parentClaim() == null && (sub = currentClaim.getSubClaim(rounded)) != null) {
                    currentClaim = sub;
                    currentClaim.displayEnterTitle(player);
                    newClaim = currentClaim;
                }
                if (!player.m_5833_()) {
                    BlockPos.MutableBlockPos bPos = rounded.m_122032_();
                    boolean isSub = currentClaim.parentClaim() != null;
                    Claim mainClaim = isSub ? currentClaim.parentClaim() : currentClaim;
                    Entity passenger = player.m_20202_();
                    if (!mainClaim.canInteract(player, BuiltinPermission.CANSTAY, (BlockPos)bPos, true) || passenger instanceof Boat && !mainClaim.canInteract(player, BuiltinPermission.BOAT, (BlockPos)bPos, true)) {
                        Claim sub2 = isSub ? currentClaim : null;
                        Vec3 tp = TeleportUtils.getTeleportPos(player, pos, storage, new TeleportUtils.Area2D(sub2 != null ? sub2.getDimensions() : mainClaim.getDimensions()), true, bPos, (claim, nPos) -> claim.canInteract(player, BuiltinPermission.CANSTAY, (BlockPos)nPos, false));
                        if (passenger != null) {
                            player.m_8127_();
                            passenger.m_20324_(tp.m_7096_(), tp.m_7098_(), tp.m_7094_());
                        }
                        player.m_20324_(tp.m_7096_(), tp.m_7098_(), tp.m_7094_());
                    }
                    rounded = bPos;
                    currentClaim.applyEffects(player);
                }
            }
        } else if (player.f_19797_ % 3 == 0) {
            Claim sub;
            Claim claim4 = storage.getClaimAt(rounded);
            Claim claim5 = sub = claim4 != null ? claim4.getSubClaim(rounded) : null;
            if (sub != null) {
                claim4 = sub;
            }
            if (claim4 != null) {
                claim4.displayEnterTitle(player);
            }
            newClaim = claim4;
        }
        IPermissionContainer iPermissionContainer = permissionContainer = newClaim != null ? newClaim : storage.getForPermissionCheck(rounded);
        if (player.m_150110_().f_35935_ && !PlayerEvents.gameModeCanFly(player.f_8941_.m_9290_()) && !permissionContainer.canInteract(player, BuiltinPermission.ALLOW_FLIGHT, rounded, true)) {
            player.m_150110_().f_35935_ = false;
            player.m_20256_(Vec3.f_82478_);
            player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            player.f_8906_.m_9829_((Packet)new ClientboundPlayerAbilitiesPacket(player.m_150110_()));
        } else if (!PlayerEvents.gameModeCanFly(player.f_8941_.m_9290_())) {
            CrossPlatformStuff.INSTANCE.toggleCreativeFlight(player, permissionContainer.canInteract(player, BuiltinPermission.MAY_FLIGHT, rounded, false));
        }
        if (player.m_36324_().m_38722_() < 2.0f && permissionContainer.canInteract(player, BuiltinPermission.NOHUNGER, rounded, false)) {
            ((IHungerAccessor)player.m_36324_()).setSaturation(2.0f);
        }
        return newClaim;
    }

    protected static boolean gameModeCanFly(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SPECTATOR;
    }
}

