/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.mixin.StructureManagerAccessor;
import io.github.flemmli97.flan.player.LogoutTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class WorldEvents {
    public static void modifyExplosion(Explosion explosion, ServerLevel world) {
        ClaimStorage storage = ClaimStorage.get(world);
        explosion.m_46081_().removeIf(pos -> {
            IPermissionContainer claim = storage.getForPermissionCheck((BlockPos)pos);
            if (claim != null) {
                return !claim.canInteract(null, BuiltinPermission.EXPLOSIONS, (BlockPos)pos);
            }
            return false;
        });
    }

    public static boolean pistonCanPush(BlockState state, Level world, BlockPos blockPos, Direction direction, Direction pistonDir) {
        if (world.f_46443_) {
            return true;
        }
        BlockPos dirPos = blockPos.m_121945_(direction);
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer from = storage.getForPermissionCheck(blockPos);
        IPermissionContainer to = storage.getForPermissionCheck(dirPos);
        boolean flag = true;
        if (from.equals(to)) {
            BlockPos oppPoos = blockPos.m_121945_(direction.m_122424_());
            IPermissionContainer opp = storage.getForPermissionCheck(oppPoos);
            if (!from.equals(opp)) {
                flag = from.canInteract(null, BuiltinPermission.PISTONBORDER, oppPoos);
            }
        } else if (!state.m_60795_()) {
            boolean bl = flag = from.canInteract(null, BuiltinPermission.PISTONBORDER, blockPos) && to.canInteract(null, BuiltinPermission.PISTONBORDER, dirPos);
        }
        if (!flag) {
            world.m_7260_(blockPos, state, state, 20);
            BlockState toState = world.m_8055_(dirPos);
            world.m_7260_(dirPos, toState, toState, 20);
        }
        return flag;
    }

    public static boolean canFlow(BlockState fluidBlockState, BlockGetter world, BlockPos blockPos, Direction direction) {
        IPermissionContainer to;
        if (!(world instanceof ServerLevel) || direction == Direction.UP || direction == Direction.DOWN) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        IPermissionContainer from = storage.getForPermissionCheck(blockPos);
        return from.equals(to = storage.getForPermissionCheck(blockPos.m_121945_(direction))) || to.canInteract(null, BuiltinPermission.WATERBORDER, blockPos);
    }

    public static boolean canStartRaid(ServerPlayer player) {
        IPermissionContainer claim = ClaimStorage.get(player.m_284548_()).getForPermissionCheck(player.m_20183_());
        return claim.canInteract(player, BuiltinPermission.RAID, player.m_20183_());
    }

    public static boolean canFireSpread(ServerLevel world, BlockPos pos) {
        IPermissionContainer claim = ClaimStorage.get(world).getForPermissionCheck(pos);
        return claim.canInteract(null, BuiltinPermission.FIRESPREAD, pos);
    }

    public static boolean preventMobSpawn(ServerLevel world, Mob entity) {
        IPermissionContainer claim = ClaimStorage.get(world).getForPermissionCheck(entity.m_20183_());
        if (entity.m_6095_().m_20674_() == MobCategory.MONSTER) {
            return claim.canInteract(null, BuiltinPermission.MOBSPAWN, entity.m_20183_());
        }
        return claim.canInteract(null, BuiltinPermission.ANIMALSPAWN, entity.m_20183_());
    }

    public static boolean lightningFire(LightningBolt lightning) {
        Level level = lightning.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return true;
        }
        ServerLevel world = (ServerLevel)level;
        BlockPos.MutableBlockPos mutable = lightning.m_20183_().m_122032_();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                mutable.m_122178_(mutable.m_123341_() + x, mutable.m_123342_(), mutable.m_123343_() + z);
                IPermissionContainer claim = ClaimStorage.get(world).getForPermissionCheck((BlockPos)mutable);
                if (claim.canInteract(null, BuiltinPermission.LIGHTNING, (BlockPos)mutable)) continue;
                return false;
            }
        }
        return true;
    }

    public static void serverTick(MinecraftServer server) {
        LogoutTracker.getInstance(server).tick();
    }

    public static void onStructureGen(StructureStart structureStart, StructureManager structureManager) {
        if (!ConfigHandler.CONFIG.autoClaimStructures) {
            return;
        }
        LevelAccessor acc = ((StructureManagerAccessor)structureManager).getLevel();
        ServerLevel level = null;
        if (acc instanceof WorldGenRegion) {
            WorldGenRegion region = (WorldGenRegion)acc;
            level = region.m_6018_();
        } else if (acc instanceof ServerLevel) {
            ServerLevel serverLevel;
            level = serverLevel = (ServerLevel)acc;
        }
        if (level == null) {
            return;
        }
        BoundingBox bb = structureStart.m_73601_();
        ClaimStorage.get(level).createAdminClaim(new BlockPos(bb.m_162395_(), bb.m_162396_(), bb.m_162398_()), new BlockPos(bb.m_162399_(), bb.m_162400_(), bb.m_162401_()), level, true);
    }
}

