/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.forge.forgeevent;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.event.BlockInteractEvents;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class BlockInteractEventsForge {
    public static void startBreakBlocks(PlayerInteractEvent.LeftClickBlock event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (BlockInteractEvents.startBreakBlocks(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace()) == InteractionResult.FAIL) {
            event.setCanceled(true);
        }
    }

    public static void breakBlocks(BlockEvent.BreakEvent event) {
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        if (!BlockInteractEvents.breakBlocks((Level)event.getLevel(), event.getPlayer(), event.getPos(), event.getState(), event.getLevel().m_7702_(event.getPos()))) {
            event.setCanceled(true);
        }
    }

    public static void useBlocks(PlayerInteractEvent.RightClickBlock event) {
        InteractionResult res = BlockInteractEvents.useBlocks(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
        if (res == InteractionResult.SUCCESS) {
            event.setCancellationResult(res);
            event.setCanceled(true);
            return;
        }
        if (res == InteractionResult.FAIL) {
            event.setUseBlock(Event.Result.DENY);
        }
        if ((res = ItemInteractEvents.onItemUseBlock(new UseOnContext(event.getEntity(), event.getHand(), event.getHitVec()))) == InteractionResult.FAIL) {
            event.setUseItem(Event.Result.DENY);
        }
    }

    public static void placeBlock(BlockEvent.EntityPlaceEvent event) {
        event.setCanceled(BlockInteractEventsForge.forgePlaceBlocks(event.getEntity(), event.getPos(), event.getPlacedBlock()));
    }

    public static void placeBlocks(BlockEvent.EntityMultiPlaceEvent event) {
        event.setCanceled(BlockInteractEventsForge.forgePlaceBlocks(event.getEntity(), event.getPos(), event.getPlacedBlock()));
    }

    private static boolean forgePlaceBlocks(Entity entity, BlockPos placePos, BlockState placedBlock) {
        if (!(entity instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ClaimStorage storage = ClaimStorage.get(player.m_284548_());
        IPermissionContainer claim = storage.getForPermissionCheck(placePos);
        if (claim == null) {
            return false;
        }
        ResourceLocation perm = InteractionOverrideManager.INSTANCE.getBlockInteract(placedBlock.m_60734_());
        if (perm != null && !claim.canInteract(player, perm, placePos, false)) {
            player.m_5661_((Component)ClaimUtils.translatedText("flan.noPermissionSimple", ChatFormatting.DARK_RED), true);
            return true;
        }
        if (!claim.canInteract(player, BuiltinPermission.PLACE, placePos, false)) {
            player.m_5661_((Component)ClaimUtils.translatedText("flan.noPermissionSimple", ChatFormatting.DARK_RED), true);
            PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.m_20183_().m_123342_());
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, player.m_150109_().f_35977_, player.m_150109_().m_36056_()));
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, 40, player.m_150109_().m_8020_(40)));
            return true;
        }
        return false;
    }
}

