/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimTextHandler;
import io.github.flemmli97.flan.gui.ConfirmScreenHandler;
import io.github.flemmli97.flan.gui.CustomInteractListScreenHandler;
import io.github.flemmli97.flan.gui.FakePlayerScreenHandler;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.PermissionScreenHandler;
import io.github.flemmli97.flan.gui.PotionEditScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;

public class ClaimMenuScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private ClaimMenuScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 2, claim);
    }

    public static void openClaimMenu(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new ClaimMenuScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return ClaimUtils.translatedText(claim.parentClaim() != null ? "flan.screenMenuSub" : "flan.screenMenu", new Object[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith() {
        block14: for (int i = 0; i < 18; ++i) {
            switch (i) {
                case 0: {
                    ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                    close.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenClose", ChatFormatting.DARK_RED));
                    ((Slot)this.f_38839_.get(i)).m_5852_(close);
                    continue block14;
                }
                case 2: {
                    ItemStack perm = new ItemStack((ItemLike)Items.f_42065_);
                    perm.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenMenuGlobal", ChatFormatting.GOLD));
                    if (!this.hasEditPerm((Claim)this.data, this.player)) {
                        ServerScreenHelper.addLore(perm, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(perm);
                    continue block14;
                }
                case 3: {
                    ItemStack group = new ItemStack((ItemLike)Items.f_42614_);
                    group.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenMenuGroup", ChatFormatting.GOLD));
                    if (!this.hasEditPerm((Claim)this.data, this.player)) {
                        ServerScreenHelper.addLore(group, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(group);
                    continue block14;
                }
                case 4: {
                    ItemStack potions = new ItemStack((ItemLike)Items.f_42589_);
                    potions.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenMenuPotion", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITPOTIONS)) {
                        ServerScreenHelper.addLore(potions, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(potions);
                    continue block14;
                }
                case 5: {
                    ItemStack sign = new ItemStack((ItemLike)Items.f_42438_);
                    sign.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenMenuClaimText", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(sign, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(sign);
                    continue block14;
                }
                case 6: {
                    ItemStack head = new ItemStack((ItemLike)Items.f_42681_);
                    head.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenMenuFakePlayers", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITPERMS)) {
                        ServerScreenHelper.addLore(head, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(head);
                    continue block14;
                }
                case 8: {
                    ItemStack delete = new ItemStack((ItemLike)Items.f_42127_);
                    delete.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenMenuDelete", ChatFormatting.RED));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(delete, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(delete);
                    continue block14;
                }
                case 11: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42589_);
                    PotionUtils.m_43549_((ItemStack)stack, (Potion)Potions.f_43599_);
                    stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(CustomInteractListScreenHandler.Type.ITEM.translationKey, ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                    continue block14;
                }
                case 12: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42390_);
                    stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(CustomInteractListScreenHandler.Type.BLOCKBREAK.translationKey, ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                    continue block14;
                }
                case 13: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42727_);
                    stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(CustomInteractListScreenHandler.Type.BLOCKUSE.translationKey, ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                    continue block14;
                }
                case 14: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42388_);
                    stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(CustomInteractListScreenHandler.Type.ENTITYATTACK.translationKey, ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                    continue block14;
                }
                case 15: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42574_);
                    stack.m_41714_((Component)ServerScreenHelper.coloredGuiText(CustomInteractListScreenHandler.Type.ENTITYUSE.translationKey, ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                    continue block14;
                }
                default: {
                    ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 2 || slot == 3 || slot == 4 || slot == 5 || slot == 6 || slot == 8 || slot >= 11 && slot <= 15;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        switch (index) {
            case 0: {
                player.m_6915_();
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if (this.hasEditPerm((Claim)this.data, player)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> PermissionScreenHandler.openClaimMenu((Player)player, (Claim)this.data, null));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (this.hasEditPerm((Claim)this.data, player)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 4: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPOTIONS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 5: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.CLAIMMESSAGE)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> ClaimTextHandler.openClaimMenu(player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 6: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> FakePlayerScreenHandler.open((Player)player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 8: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITCLAIM)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> ConfirmScreenHandler.openConfirmScreen(player, bool -> {
                        if (bool.booleanValue()) {
                            ClaimStorage storage = ClaimStorage.get(player.m_284548_());
                            storage.deleteClaim((Claim)this.data, true, PlayerClaimData.get(player).getClaimMode(), player.m_284548_());
                            player.m_6915_();
                            player.m_5661_((Component)ClaimUtils.translatedText("flan.deleteClaim", ChatFormatting.RED), false);
                            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11669_, 1.0f, 1.0f);
                        } else {
                            player.m_6915_();
                            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
                            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                        }
                    }));
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 11: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, CustomInteractListScreenHandler.Type.ITEM, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 12: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, CustomInteractListScreenHandler.Type.BLOCKBREAK, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 13: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, CustomInteractListScreenHandler.Type.BLOCKUSE, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 14: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, CustomInteractListScreenHandler.Type.ENTITYATTACK, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                break;
            }
            case 15: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, CustomInteractListScreenHandler.Type.ENTITYUSE, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }
        }
        return true;
    }

    private boolean hasEditPerm(Claim claim, ServerPlayer player) {
        return claim.parentClaim() != null && claim.parentClaim().canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_()) || claim.canInteract(player, BuiltinPermission.EDITPERMS, player.m_20183_());
    }

    private boolean hasPerm(Claim claim, ServerPlayer player, ResourceLocation perm) {
        if (claim.parentClaim() != null) {
            return claim.parentClaim().canInteract(player, perm, player.m_20183_());
        }
        return claim.canInteract(player, perm, player.m_20183_());
    }
}

