/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ClaimTextHandler
extends ServerOnlyScreenHandler<Claim> {
    private ClaimTextHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 1, claim);
    }

    public static void openClaimMenu(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new ClaimTextHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return ClaimUtils.translatedText(claim.parentClaim() != null ? "flan.screenTitleEditorSub" : "flan.screenTitleEditor", new Object[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith() {
        block7: for (int i = 0; i < 9; ++i) {
            switch (i) {
                case 0: {
                    ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                    close.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                    ((Slot)this.f_38839_.get(i)).m_5852_(close);
                    continue block7;
                }
                case 2: {
                    ItemStack stack = new ItemStack((ItemLike)Items.f_42438_);
                    stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenEnterText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList<Component>();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).enterTitle != null) {
                        lore.add(((Claim)this.data).enterTitle);
                    }
                    ServerScreenHelper.addLore(stack, lore);
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                    continue block7;
                }
                case 3: {
                    ItemStack stack2 = new ItemStack((ItemLike)Items.f_42438_);
                    stack2.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenEnterSubText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).enterSubtitle != null) {
                        lore.add(((Claim)this.data).enterSubtitle);
                    }
                    ServerScreenHelper.addLore(stack2, lore);
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack2);
                    continue block7;
                }
                case 4: {
                    ItemStack stack3 = new ItemStack((ItemLike)Items.f_42438_);
                    stack3.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenLeaveText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).leaveTitle != null) {
                        lore.add(((Claim)this.data).leaveTitle);
                    }
                    ServerScreenHelper.addLore(stack3, lore);
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack3);
                    continue block7;
                }
                case 5: {
                    ItemStack stack4 = new ItemStack((ItemLike)Items.f_42438_);
                    stack4.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenLeaveSubText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).leaveSubtitle != null) {
                        lore.add(((Claim)this.data).leaveSubtitle);
                    }
                    ServerScreenHelper.addLore(stack4, lore);
                    ((Slot)this.f_38839_.get(i)).m_5852_(stack4);
                    continue block7;
                }
                default: {
                    ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 2 || slot == 3 || slot == 4 || slot == 5 || slot == 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
        } else {
            Consumer<Component> cons;
            switch (index) {
                case 2: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setEnterTitle((Component)text, ((Claim)this.data).enterSubtitle);
                    break;
                }
                case 3: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setEnterTitle(((Claim)this.data).enterTitle, (Component)text);
                    break;
                }
                case 4: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setLeaveTitle((Component)text, ((Claim)this.data).leaveSubtitle);
                    break;
                }
                case 5: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setLeaveTitle(((Claim)this.data).leaveTitle, (Component)text);
                    break;
                }
                default: {
                    Consumer<Component> consumer = cons = null;
                }
            }
            if (cons != null) {
                player.m_6915_();
                if (clickType == 0) {
                    player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                        player.m_6915_();
                        cons.accept((Component)Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(false)).m_131157_(ChatFormatting.WHITE)));
                        player.m_20194_().execute(() -> ClaimTextHandler.openClaimMenu(player, (Claim)this.data));
                        ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
                    }, () -> {
                        player.m_6915_();
                        player.m_20194_().execute(() -> ClaimTextHandler.openClaimMenu(player, (Claim)this.data));
                        ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                    }));
                } else {
                    MutableComponent text2 = ClaimUtils.translatedText("flan.chatClaimTextEdit", new Object[0]);
                    String command = "/flan claimMessage" + (index == 2 || index == 3 ? " enter" : " leave") + (index == 2 || index == 4 ? " title" : " subtitle") + " text ";
                    text2.m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                    player.m_5661_((Component)text2, false);
                }
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            }
        }
        return true;
    }
}

