/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class FakePlayerScreenHandler
extends PagedServerOnlyScreenHandler<Claim> {
    private boolean removeMode;

    private FakePlayerScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
    }

    public static void open(Player player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new FakePlayerScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return ClaimUtils.translatedText("flan.screenMenuFakePlayers", new Object[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith() {
        List<String> players = ((Claim)this.data).getAllowedFakePlayerUUID();
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(close);
                continue;
            }
            if (i == 3) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i == 4) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < players.size()) {
                ItemStack fakePlayer = new ItemStack((ItemLike)Items.f_42681_);
                fakePlayer.m_41784_().m_128359_("FlanFakePlayer", players.get(id));
                fakePlayer.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenFakePlayerNameUUID", players.get(id), ChatFormatting.YELLOW));
                ((Slot)this.f_38839_.get(i)).m_5852_(fakePlayer);
                continue;
            }
            ((Slot)this.f_38839_.get(i)).m_5852_(ItemStack.f_41583_);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                boolean fl = player.m_20194_().m_129927_().m_10996_(s).map(prof -> ((Claim)this.data).modifyFakePlayerUUID(prof.getId(), false)).orElse(true);
                player.m_6915_();
                player.m_20194_().execute(() -> FakePlayerScreenHandler.open((Player)player, (Claim)this.data));
                if (fl) {
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
                } else {
                    player.m_5661_((Component)ClaimUtils.translatedText("flan.playerGroupAddFail", ChatFormatting.RED), false);
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                }
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> FakePlayerScreenHandler.open((Player)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(stack.m_41784_().m_128461_("FlanFakePlayer"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.removeMode && uuid != null) {
                ((Claim)this.data).modifyFakePlayerUUID(uuid, true);
                slot.m_5852_(ItemStack.f_41583_);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((Claim)this.data).getAllowedFakePlayerUUID().size() - 1) / 28, 47, 51);
    }
}

