/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.GroupPlayerScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.PermissionScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GroupScreenHandler
extends PagedServerOnlyScreenHandler<Claim> {
    private boolean removeMode;

    private GroupScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
    }

    public static void openGroupMenu(Player player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new GroupScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return ClaimUtils.translatedText("flan.screenGroups", new Object[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith() {
        for (int i = 0; i < 54; ++i) {
            ItemStack stack;
            if (i == 0) {
                stack = new ItemStack((ItemLike)Items.f_41996_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i == 3) {
                stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i == 4) {
                stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                continue;
            }
            List<String> groups = ((Claim)this.data).groups();
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < groups.size()) {
                ItemStack group = new ItemStack((ItemLike)Items.f_42516_);
                group.m_41784_().m_128359_("FlanGroup", groups.get(id));
                group.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenGroupName", groups.get(id), ChatFormatting.DARK_BLUE));
                ((Slot)this.f_38839_.get(i)).m_5852_(group);
                continue;
            }
            ((Slot)this.f_38839_.get(i)).m_5852_(ItemStack.f_41583_);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                ((Claim)this.data).editPerms(player, (String)s, BuiltinPermission.EDITPERMS, -1);
                player.m_6915_();
                player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_()) {
            String name = stack.m_41784_().m_128461_("FlanGroup");
            if (this.removeMode) {
                ((Claim)this.data).removePermGroup(player, name);
                slot.m_5852_(ItemStack.f_41583_);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
            } else {
                if (clickType == 1) {
                    player.m_6915_();
                    player.m_20194_().execute(() -> PermissionScreenHandler.openClaimMenu((Player)player, (Claim)this.data, name));
                } else {
                    player.m_6915_();
                    player.m_20194_().execute(() -> GroupPlayerScreenHandler.openPlayerGroupMenu((Player)player, (Claim)this.data, name));
                }
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((Claim)this.data).groups().size() - 1) / 28, 47, 51);
    }
}

