/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.mixin.AbstractContainerAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public abstract class PagedServerOnlyScreenHandler<T>
extends ServerOnlyScreenHandler<T> {
    private int page;

    protected PagedServerOnlyScreenHandler(int syncId, Inventory playerInventory, int rows, T additionalData) {
        super(syncId, playerInventory, rows, additionalData);
    }

    @Override
    protected final void setupGui() {
        ItemStack stack;
        super.setupGui();
        PageSettings settings = this.pageSettings();
        if (this.page >= 1 && settings.previousSlot() != -1) {
            stack = new ItemStack((ItemLike)Items.f_42412_);
            stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenPrevious", ChatFormatting.WHITE));
            ((Slot)this.f_38839_.get(settings.previousSlot())).m_5852_(stack);
        }
        if (this.page < settings.maxPages() && settings.nextSlot() != -1) {
            stack = new ItemStack((ItemLike)Items.f_42412_);
            stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenNext", ChatFormatting.WHITE));
            ((Slot)this.f_38839_.get(settings.nextSlot())).m_5852_(stack);
        }
    }

    @Override
    public boolean m_6875_(Player player) {
        return true;
    }

    @Override
    public void m_150399_(int i, int j, ClickType clickType, Player player) {
        if (this.handlePageFlip(i)) {
            for (ContainerListener listener : ((AbstractContainerAccessor)((Object)this)).listeners()) {
                listener.m_7934_((AbstractContainerMenu)this, i, ((Slot)this.f_38839_.get(i)).m_7993_().m_41777_());
            }
            return;
        }
        super.m_150399_(i, j, clickType, player);
    }

    @Override
    public ItemStack m_7648_(Player player, int index) {
        if (index < 0) {
            return ItemStack.f_41583_;
        }
        if (this.handlePageFlip(index)) {
            return ((Slot)this.f_38839_.get(index)).m_7993_().m_41777_();
        }
        return super.m_7648_(player, index);
    }

    private boolean handlePageFlip(int slot) {
        boolean next;
        PageSettings settings = this.pageSettings();
        boolean previous = this.page > 0 && settings.previousSlot() != -1 && slot == settings.previousSlot();
        boolean bl = next = this.page < settings.maxPages() && settings.nextSlot() != -1 && slot == settings.nextSlot();
        if (previous || next) {
            if (previous) {
                this.flipPrevious();
            } else {
                this.flipNext();
            }
            return true;
        }
        return false;
    }

    protected abstract PageSettings pageSettings();

    public int getPage() {
        return this.page;
    }

    public void flipNext() {
        this.page = Math.min(this.pageSettings().maxPages(), ++this.page);
        ServerScreenHelper.playSongToPlayer(this.player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
        this.setupGui();
        this.m_38946_();
    }

    public void flipPrevious() {
        this.page = Math.max(0, --this.page);
        ServerScreenHelper.playSongToPlayer(this.player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
        this.setupGui();
        this.m_38946_();
    }

    public record PageSettings(int maxPages, int previousSlot, int nextSlot) {
    }
}

