/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.PersonalGroupScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class PersonalPermissionScreenHandler
extends PagedServerOnlyScreenHandler<String> {
    private List<ClaimPermission> perms;

    private PersonalPermissionScreenHandler(int syncId, Inventory playerInventory, String group) {
        super(syncId, playerInventory, 6, group);
    }

    public static void openClaimMenu(Player player, final String group) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new PersonalPermissionScreenHandler(syncId, inv, group);
            }

            public Component m_5446_() {
                return ClaimUtils.translatedText("flan.screenPersonalPermissions", group);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith() {
        this.perms = new ArrayList<ClaimPermission>(PermissionManager.INSTANCE.getAll());
        if (this.data != null) {
            this.perms.removeIf(p -> p.global);
        }
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(close);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < this.perms.size()) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.getFromPersonal(this.player, this.perms.get(id), (String)this.data));
                continue;
            }
            ((Slot)this.f_38839_.get(i)).m_5852_(ItemStack.f_41583_);
        }
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        ClaimPermission perm;
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> PersonalGroupScreenHandler.openGroupMenu((Player)player));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        try {
            perm = PermissionManager.INSTANCE.get(new ResourceLocation(stack.m_41783_().m_128461_("flan.permission")));
            if (perm == null) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        Map perms = data.playerDefaultGroups().getOrDefault(this.data, new HashMap());
        boolean success = data.editDefaultPerms((String)this.data, perm.getId(), (perms.containsKey(perm.getId()) ? (((Boolean)perms.get(perm.getId())).booleanValue() ? 1 : 0) : -1) + 1);
        slot.m_5852_(ServerScreenHelper.getFromPersonal(player, perm, (String)this.data));
        if (success) {
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12216_, 1.0f, 1.2f);
        } else {
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((this.perms.size() - 1) / 28, 47, 51);
    }
}

