/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.google.common.collect.Lists;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;

public class PotionEditScreenHandler
extends PagedServerOnlyScreenHandler<Claim> {
    private boolean removeMode;

    protected PotionEditScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
    }

    public static void openPotionMenu(Player player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu m_7208_(int syncId, Inventory inv, Player player) {
                return new PotionEditScreenHandler(syncId, inv, claim);
            }

            public Component m_5446_() {
                return ClaimUtils.translatedText("flan.screenPotions", new Object[0]);
            }
        };
        player.m_5893_(fac);
    }

    @Override
    protected void fillInventoryWith() {
        Map<MobEffect, Integer> potions = ((Claim)this.data).getPotions();
        ArrayList key = Lists.newArrayList(potions.keySet());
        key.sort(Comparator.comparing(eff -> BuiltInRegistries.f_256974_.m_7981_(eff).toString()));
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack close = new ItemStack((ItemLike)Items.f_41996_);
                close.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(close);
                continue;
            }
            if (i == 3) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42146_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i == 4) {
                ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
                stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), ChatFormatting.DARK_RED));
                ((Slot)this.f_38839_.get(i)).m_5852_(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.f_38839_.get(i)).m_5852_(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < potions.size()) {
                MobEffect effect = (MobEffect)key.get(id);
                ItemStack effectStack = new ItemStack((ItemLike)Items.f_42589_);
                MutableComponent txt = ClaimUtils.translatedText(effect.m_19481_(), new Object[0]);
                Set<MobEffectInstance> inst = Collections.singleton(new MobEffectInstance(effect, 0, potions.get(effect).intValue()));
                effectStack.m_41784_().m_128359_("FlanEffect", BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString());
                effectStack.m_41783_().m_128405_("CustomPotionColor", PotionUtils.m_43564_(inst));
                txt.m_7220_((Component)Component.m_237113_((String)("-" + String.valueOf(potions.get(effect)))));
                MutableComponent comp = ServerScreenHelper.coloredGuiText("flan.screenPotionText", txt, ChatFormatting.DARK_BLUE);
                effectStack.m_41714_((Component)comp);
                ((Slot)this.f_38839_.get(i)).m_5852_(effectStack);
                continue;
            }
            ((Slot)this.f_38839_.get(i)).m_5852_(ItemStack.f_41583_);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.m_6915_();
            player.m_20194_().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.m_6915_();
            player.m_20194_().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                String[] potion = s.split(";");
                int amp = 1;
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(potion[0]));
                if (effect == null || effect == MobEffects.f_19621_ && !potion[0].equals("minecraft:luck")) {
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
                    return;
                }
                if (potion.length > 1) {
                    try {
                        amp = Integer.parseInt(potion[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ((Claim)this.data).addPotion(effect, amp);
                player.m_6915_();
                player.m_20194_().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11671_, 1.0f, 1.0f);
            }, () -> {
                player.m_6915_();
                player.m_20194_().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_12507_, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42153_);
            stack.m_41714_((Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode ? ServerScreenHelper.coloredGuiText("flan.screenTrue", new Object[0]) : ServerScreenHelper.coloredGuiText("flan.screenFalse", new Object[0]), ChatFormatting.DARK_RED));
            slot.m_5852_(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.f_12490_, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.m_7993_();
        if (!stack.m_41619_() && this.removeMode) {
            String effect = stack.m_41784_().m_128461_("FlanEffect");
            ((Claim)this.data).removePotion((MobEffect)BuiltInRegistries.f_256974_.m_7745_(new ResourceLocation(effect)));
            slot.m_5852_(ItemStack.f_41583_);
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.f_11732_, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((Claim)this.data).getPotions().size() - 1) / 28, 47, 51);
    }
}

